% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_count_boundaries}
\alias{stri_count_boundaries}
\alias{stri_count_words}
\title{Count the Number of Text Boundaries}
\usage{
stri_count_boundaries(str, ..., opts_brkiter = NULL)

stri_count_words(str, locale = NULL)
}
\arguments{
\item{str}{character vector or an object coercible to}

\item{...}{additional settings for \code{opts_brkiter}}

\item{opts_brkiter}{a named list with \pkg{ICU} BreakIterator's settings
as generated with \code{\link{stri_opts_brkiter}};
\code{NULL} for default break iterator, i.e. \code{line_break};
\code{stri_count_boundaries} only}

\item{locale}{\code{NULL} or \code{""} for text boundary analysis following
the conventions of the default locale, or a single string with
locale identifier, see \link{stringi-locale};
\code{stri_count_words} only}
}
\value{
Both functions return an integer vector.
}
\description{
This function determines the number of specific text boundaries
(like character, word, line, or sentence boundaries) in a string.
}
\details{
Vectorized over \code{str}.

For more information on the text boundary analysis
performed by \pkg{ICU}'s \code{BreakIterator}, see
\link{stringi-search-boundaries}.

In case of \code{stri_count_words},
just like in \code{\link{stri_extract_all_words}} and
\code{\link{stri_locate_all_words}},
\pkg{ICU}'s word \code{BreakIterator} iterator is used
to locate word boundaries, and all non-word characters
(\code{UBRK_WORD_NONE} rule status) are ignored.
This is function is equivalent to a call to
\code{\link{stri_count_boundaries}(str, type="word", skip_word_none=TRUE, locale=locale)}

Note that a \code{BreakIterator} of type \code{character}
may be used to count the number of \emph{Unicode characters} in a string.
This may lead to different results than that returned by the
\code{\link{stri_length}} function, which is designed to return
the number of \emph{Unicode code points}.

On the other hand, a \code{BreakIterator} of type \code{sentence}
may be used to count the number of sentences in a piece of text.
}
\examples{
test <- "The\\u00a0above-mentioned    features are very useful. Warm thanks to their developers."
stri_count_boundaries(test, type="word")
stri_count_boundaries(test, type="sentence")
stri_count_boundaries(test, type="character")
stri_count_words(test)

test2 <- stri_trans_nfkd("\\u03c0\\u0153\\u0119\\u00a9\\u00df\\u2190\\u2193\\u2192")
stri_count_boundaries(test2, type="character")
stri_length(test2)
stri_numbytes(test2)
}
\seealso{
Other locale_sensitive: \code{\link{\%s!==\%}},
  \code{\link{\%s!=\%}}, \code{\link{\%s<=\%}},
  \code{\link{\%s<\%}}, \code{\link{\%s===\%}},
  \code{\link{\%s==\%}}, \code{\link{\%s>=\%}},
  \code{\link{\%s>\%}}, \code{\link{\%stri!==\%}},
  \code{\link{\%stri!=\%}}, \code{\link{\%stri<=\%}},
  \code{\link{\%stri<\%}}, \code{\link{\%stri===\%}},
  \code{\link{\%stri==\%}}, \code{\link{\%stri>=\%}},
  \code{\link{\%stri>\%}}; \code{\link{stri_cmp}},
  \code{\link{stri_cmp_eq}}, \code{\link{stri_cmp_equiv}},
  \code{\link{stri_cmp_ge}}, \code{\link{stri_cmp_gt}},
  \code{\link{stri_cmp_le}}, \code{\link{stri_cmp_lt}},
  \code{\link{stri_cmp_neq}},
  \code{\link{stri_cmp_nequiv}},
  \code{\link{stri_compare}};
  \code{\link{stri_duplicated}},
  \code{\link{stri_duplicated_any}};
  \code{\link{stri_enc_detect2}};
  \code{\link{stri_extract_all_words}},
  \code{\link{stri_extract_first_words}},
  \code{\link{stri_extract_last_words}};
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_locate_all_words}},
  \code{\link{stri_locate_first_boundaries}},
  \code{\link{stri_locate_first_words}},
  \code{\link{stri_locate_last_boundaries}},
  \code{\link{stri_locate_last_words}};
  \code{\link{stri_opts_collator}};
  \code{\link{stri_order}}, \code{\link{stri_sort}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_unique}}; \code{\link{stri_wrap}};
  \code{\link{stringi-locale}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search-coll}}

Other search_count: \code{\link{stri_count}},
  \code{\link{stri_count_charclass}},
  \code{\link{stri_count_coll}},
  \code{\link{stri_count_fixed}},
  \code{\link{stri_count_regex}};
  \code{\link{stringi-search}}

Other text_boundaries: \code{\link{stri_extract_all_words}},
  \code{\link{stri_extract_first_words}},
  \code{\link{stri_extract_last_words}};
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_locate_all_words}},
  \code{\link{stri_locate_first_boundaries}},
  \code{\link{stri_locate_first_words}},
  \code{\link{stri_locate_last_boundaries}},
  \code{\link{stri_locate_last_words}};
  \code{\link{stri_opts_brkiter}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_split_lines}},
  \code{\link{stri_split_lines1}},
  \code{\link{stri_split_lines1}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_wrap}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search}}
}

