% Generated by roxygen2 (4.0.2): do not edit by hand
\name{stri_split_lines}
\alias{stri_split_lines}
\alias{stri_split_lines1}
\title{Split a String Into Text Lines}
\usage{
stri_split_lines(str, omit_empty = FALSE)

stri_split_lines1(str)
}
\arguments{
\item{str}{character vector (\code{stri_split_lines})
or a single string (\code{stri_split_lines1})}

\item{omit_empty}{logical vector; determines whether empty
strings should be removed from the result
   [\code{stri_split_lines} only]}
}
\value{
\code{stri_split_lines} returns a list of character vectors.
If any input string is \code{NA}, then the corresponding list element
is a single \code{NA} string.

\code{stri_split_lines1(str)} is equivalent to
\code{stri_split_lines(str[1])[[1]]} (with default parameters),
thus it returns a character vector. Moreover, if the input string ends at
a newline sequence, the last empty string is omitted from the result.
Therefore, this function may be handy if you wish to split a loaded text
file into text lines.
}
\description{
These functions split each character string into text lines.
}
\details{
Vectorized over \code{str} and \code{omit_empty}.

\code{omit_empty} is applied during splitting. If it is set to \code{TRUE},
then empty strings will never appear in the resulting vector.

Newlines are represented on different platforms e.g. by carriage return
(CR, 0x0D), line feed (LF, 0x0A), CRLF, or next line (NEL, 0x85).
Moreover, the Unicode Standard defines two unambiguous separator characters,
Paragraph Separator (PS, 0x2029) and Line Separator (LS, 0x2028).
Sometimes also vertical tab (VT, 0x0B) and form feed (FF, 0x0C)
are used. These functions follow UTR#18 rules, where a newline sequence
corresponds to the following regular expression:
\code{(?:\\u\{D A\}|(?!\\u\{D A\})[\\u\{A\}-\\u\{D\}\\u\{85\}\\u\{2028\}\\u\{2029\}]}.
Each match is used to split a text line. For efficiency reasons, the search
here is not performed by the regex engine, however.
}
\references{
\emph{Unicode Newline Guidelines} -- Unicode Technical Report #13,
\url{http://www.unicode.org/standard/reports/tr13/tr13-5.html}

\emph{Unicode Regular Expressions} -- Unicode Technical Standard #18,
\url{http://www.unicode.org/reports/tr18/}
}
\seealso{
Other search_split: \code{\link{stri_split_boundaries}};
  \code{\link{stri_split}},
  \code{\link{stri_split_charclass}},
  \code{\link{stri_split_coll}},
  \code{\link{stri_split_fixed}},
  \code{\link{stri_split_regex}};
  \code{\link{stringi-search}}

Other text_boundaries: \code{\link{stri_count_boundaries}},
  \code{\link{stri_count_words}};
  \code{\link{stri_extract_all_words}},
  \code{\link{stri_extract_first_words}},
  \code{\link{stri_extract_last_words}};
  \code{\link{stri_locate_all_boundaries}},
  \code{\link{stri_locate_all_words}},
  \code{\link{stri_locate_first_boundaries}},
  \code{\link{stri_locate_first_words}},
  \code{\link{stri_locate_last_boundaries}},
  \code{\link{stri_locate_last_words}};
  \code{\link{stri_opts_brkiter}};
  \code{\link{stri_split_boundaries}};
  \code{\link{stri_trans_tolower}},
  \code{\link{stri_trans_totitle}},
  \code{\link{stri_trans_toupper}};
  \code{\link{stri_wrap}};
  \code{\link{stringi-search-boundaries}};
  \code{\link{stringi-search}}
}

