% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/length.R
\name{stri_length}
\alias{stri_length}
\title{Count the Number of Code Points}
\usage{
stri_length(str)
}
\arguments{
\item{str}{character vector or an object coercible to}
}
\value{
Returns an integer vector of the same length as \code{str}.
}
\description{
This function returns the number of code points
in each string.
}
\details{
Note that the number of code points is
not the same as the `width` of the string when
printed on the console.

If a given string is in UTF-8 and has not been properly normalized
(e.g., by \code{\link{stri_trans_nfc}}), the returned counts may sometimes be
misleading. See \code{\link{stri_count_boundaries}} for a method to count
\emph{Unicode characters}. Moreover, if an incorrect UTF-8 byte sequence
is detected, then a warning is generated and the corresponding output element
is set to \code{NA}, see also \code{\link{stri_enc_toutf8}} for a method
to deal with such cases.

Missing values are handled properly.
For `byte` encodings we get, as usual, an error.
}
\examples{
stri_length(LETTERS)
stri_length(c('abc', '123', '\u0105\u0104'))
stri_length('\u0105') # length is one, but...
stri_numbytes('\u0105') # 2 bytes are used
stri_numbytes(stri_trans_nfkd('\u0105')) # 3 bytes here but...
stri_length(stri_trans_nfkd('\u0105')) # ...two code points (!)
stri_count_boundaries(stri_trans_nfkd('\u0105'), type='character') # ...and one Unicode character

}
\seealso{
Other length: 
\code{\link{stri_isempty}()},
\code{\link{stri_numbytes}()},
\code{\link{stri_width}()}
}
\concept{length}
