% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_tools.R
\name{string_extract}
\alias{string_extract}
\alias{stextract}
\title{Extracts a pattern from a character vector}
\usage{
string_extract(
  x,
  pattern,
  single = FALSE,
  simplify = TRUE,
  fixed = FALSE,
  ignore.case = FALSE,
  word = FALSE,
  unlist = FALSE,
  envir = parent.frame()
)

stextract(
  x,
  pattern,
  single = FALSE,
  simplify = TRUE,
  fixed = FALSE,
  ignore.case = FALSE,
  word = FALSE,
  unlist = FALSE,
  envir = parent.frame()
)
}
\arguments{
\item{x}{A character vector.}

\item{pattern}{A character scalar. It represents the pattern
to be extracted from \code{x}. By default
this is a regular expression. You can use flags in the pattern in
the form \verb{flag1, flag2/pattern}.
Available flags are \code{ignore} (case), \code{fixed} (no regex), word (add word boundaries),
single (select only the first element), and magic (add interpolation with \code{{}}) . Example:
if \code{"ignore/hello"} and \verb{x = "Hello world} extracted text is \code{"Hello"}.
Shortcut: use the first letters of the flags. Ex: "iw/one" will extract the word
"one" (flags 'ignore' + 'word').}

\item{single}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, only the first pattern
that is detected will be returned. Note that in that case, a character vector is returned
of the same length as the vector in input.}

\item{simplify}{Logical scalar, default is \code{TRUE}. If \code{TRUE}, then when the vector input \code{x}
is of length 1, a character vector is returned instead of a list.}

\item{fixed}{Logical scalar, default is \code{FALSE}. Whether to trigger a fixed search instead of a
regular expression search (default).}

\item{ignore.case}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, then case insensitive search is triggered.}

\item{word}{Logical scalar, default is \code{FALSE}. If \code{TRUE} then a) word boundaries are added to the pattern,
and b) patterns can be chained by separating them with a comma, they are combined with an OR logical operation.
Example: if \code{word = TRUE}, then pattern = "The, mountain" will select strings containing either the word
'The' or the word 'mountain'.}

\item{unlist}{Logical scalar, default is \code{FALSE}. If \code{TRUE}, the function \code{unlist} is applied
to the resulting list, leading to a character vector in output (instead of a list).}

\item{envir}{Environment in which to evaluate the interpolations if the flag \code{"magic"} is provided.
Default is \code{parent.frame()}.}
}
\value{
The object returned by this functions can be a list or a character vector.

If \code{single = TRUE}, a character vector is returned, containing the value of the first match.
If no match is found, an empty string is returned.

If \code{single = FALSE} (the default) and \code{simplify = TRUE} (default), the object returned is:
\itemize{
\item a character vector if \code{x}, the vector in input, is of length 1: the character vector contains
all the matches and is of length 0 if no match is found.
\item a list of the same length as \code{x}. The ith element of the list is a character vector
of the matches for the ith element of \code{x}.
}

If \code{single = FALSE} (default) and \code{simplify = FALSE}, the object returned is always a list.
}
\description{
Extracts the first, or several, patterns from a character vector.
}
\section{Functions}{
\itemize{
\item \code{stextract()}: Alias to \code{string_extract}

}}
\section{Generic regular expression flags}{


All \code{stringmagic} functions support generic flags in regular-expression patterns.
The flags are useful to quickly give extra instructions, similarly to \emph{usual}
\href{https://javascript.info/regexp-introduction}{regular expression flags}.

Here the syntax is "flag1, flag2/pattern". That is: flags are a comma separated list of flag-names
separated from the pattern with a slash (\code{/}). Example: \code{string_which(c("hello...", "world"), "fixed/.")} returns \code{1}.
Here the flag "fixed" removes the regular expression meaning of "." which would have otherwise meant \emph{"any character"}.
The no-flag verion \code{string_which(c("hello...", "world"), ".")} returns \code{1:2}.

Alternatively, and this is recommended, you can collate the initials of the flags instead of using a
comma separated list. For example: "if/dt[" will apply the flags "ignore" and "fixed" to the pattern "dt[".

The four flags always available are: "ignore", "fixed", "word" and "magic".
\itemize{
\item "ignore" instructs to ignore the case. Technically, it adds the perl-flag "(?i)"
at the beginning of the pattern.
\item "fixed" removes the regular expression interpretation, so that the characters ".", "$", "^", "["
(among others) lose their special meaning and are treated for what they are: simple characters.
\item "word" adds word boundaries (\code{"\\\\b"} in regex language) to the pattern. Further, the comma (\code{","})
becomes a word separator. Technically, "word/one, two" is treated as "\\b(one|two)\\b". Example:
\code{string_clean("Am I ambushed?", "wi/am")} leads to " I ambushed?" thanks to the flags "ignore" and "word".
\item "magic" allows to interpolate variables inside the pattern before regex interpretation.
For example if \code{letters = "aiou"} then \code{string_clean("My great goose!", "magic/[{letters}] => e")}
leads to \code{"My greet geese!"}
}
}

\examples{

cars = head(row.names(mtcars))

# Let's extract the first word:
string_extract(cars, "\\\\w+", single = TRUE)

# same using flags
string_extract(cars, "s/\\\\w+")

# extract all words composed on only letters
# NOTE: we use the flag word (`w/`)
string_extract(cars, "w/[[:alpha:]]+")

# version without flag:
string_extract(cars, "\\\\b[[:alpha:]]+\\\\b")

# If a vector of length 1 => a vector is returned
greet = "Hi Tom, how's Mary doing?"
string_extract(greet, "w/[[:upper:]]\\\\w+")

# version with simplify = FALSE => a list is returned
string_extract(greet, "w/[[:upper:]]\\\\w+", simplify = FALSE)

}
