% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subset.R
\name{str_subset}
\alias{str_subset}
\title{Find matching elements}
\usage{
str_subset(string, pattern, negate = FALSE)
}
\arguments{
\item{string}{Input vector. Either a character vector, or something
coercible to one.}

\item{pattern}{Pattern to look for.

The default interpretation is a regular expression, as described in
\code{vignette("regular-expressions")}. Use \code{\link[=regex]{regex()}} for finer control of the
matching behaviour.

Match a fixed string (i.e. by comparing only bytes), using
\code{\link[=fixed]{fixed()}}. This is fast, but approximate. Generally,
for matching human text, you'll want \code{\link[=coll]{coll()}} which
respects character matching rules for the specified locale.

Match character, word, line and sentence boundaries with
\code{\link[=boundary]{boundary()}}. An empty pattern, "", is equivalent to
\code{boundary("character")}.}

\item{negate}{If \code{TRUE}, return non-matching elements.}
}
\value{
A character vector, usually smaller than \code{string}.
}
\description{
\code{str_subset()} returns all elements of \code{string} where there's at least
one match to \code{pattern}. It's a wrapper around \code{x[str_detect(x, pattern)]},
and is equivalent to \code{grep(pattern, x, value = TRUE)}.

Use \code{\link[=str_extract]{str_extract()}} to find the location of the match \emph{within} each string.
}
\examples{
fruit <- c("apple", "banana", "pear", "pineapple")
str_subset(fruit, "a")

str_subset(fruit, "^a")
str_subset(fruit, "a$")
str_subset(fruit, "b")
str_subset(fruit, "[aeiou]")

# Elements that don't match
str_subset(fruit, "^p", negate = TRUE)

# Missings never match
str_subset(c("a", NA, "b"), ".")
}
\seealso{
\code{\link[=grep]{grep()}} with argument \code{value = TRUE},
\code{\link[stringi:stri_subset]{stringi::stri_subset()}} for the underlying implementation.
}
