% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregextr.R
\name{regextr2}
\alias{regextr2}
\alias{gregextr2}
\alias{regextr2<-}
\alias{gregextr2<-}
\title{Extract Pattern Occurrences}
\usage{
regextr2(
  x,
  pattern,
  ...,
  ignore_case = FALSE,
  fixed = FALSE,
  capture_groups = FALSE
)

gregextr2(
  x,
  pattern,
  ...,
  ignore_case = FALSE,
  fixed = FALSE,
  capture_groups = FALSE
)

regextr2(x, pattern, ..., ignore_case = FALSE, fixed = FALSE) <- value

gregextr2(x, pattern, ..., ignore_case = FALSE, fixed = FALSE) <- value
}
\arguments{
\item{x}{character vector whose elements are to be examined}

\item{pattern}{character vector of nonempty search patterns}

\item{...}{further arguments to \code{\link[stringi]{stri_locate}},
e.g., \code{omit_empty}, \code{locale}, \code{dotall}}

\item{ignore_case}{single logical value; indicates whether matching
should be case-insensitive}

\item{fixed}{single logical value;
\code{FALSE} for matching with regular expressions
    (see \link[stringi]{about_search_regex});
\code{TRUE} for fixed pattern matching
    (\link[stringi]{about_search_fixed});
\code{NA} for the Unicode collation algorithm
    (\link[stringi]{about_search_coll})}

\item{capture_groups}{single logical value; whether matches
individual capture groups should be extracted separately}

\item{value}{character vector  (for \code{regextr})
or list of character vectors  (for \code{gregextr})
defining the replacement strings}
}
\value{
\code{capture_groups} is \code{FALSE},
\code{regextr2} returns a character vector and
\code{gregextr2} gives a list of character vectors.

Otherwise, \code{regextr2} returns a list of character vectors,
giving the whole match as well as matches to the individual capture groups.
In \code{gregextr2}, this will be a matrix with as many columns
as there are matches.

Missing values in the inputs are propagated consistently.
In \code{regextr2}, a no-match is always denoted with \code{NA}
(or series thereof). In \code{gregextr2}, the corresponding result is
empty (unless we mean a no-match to an optional capture group within
a matching substring). Note that this function distinguishes
between a missing input and a no-match.

Their replacement versions return a character vector.

These functions preserve the attributes of the longest inputs (unless they
are dropped due to coercion).
}
\description{
\code{regextr2} and \code{gregextr2} extract, respectively, first and all
(i.e., \bold{g}lobally) occurrences of a pattern.
Their replacement versions substitute the matching substrings with
new content.
}
\details{
Convenience functions based on \code{\link{gregexpr2}}
and \code{\link{gsubstrl}} (amongst others).
Provided as pipe operator-friendly alternatives
to [DEPRECATED] \code{\link[base]{regmatches}} and
[DEPRECATED] \code{\link[utils]{strcapture}}.

They are fully vectorised with respect to \code{x},
\code{pattern}, and \code{value}.

Note that, unlike in \code{\link{gsub2}},
each substituted chunk can be replaced with different content.
However, references to matches to capture groups cannot be made.
}
\examples{
x <- c(aca1="acacaca", aca2="gaca", noaca="actgggca", na=NA)
regextr2(x, "(?<x>a)(?<y>cac?)")
gregextr2(x, "(?<x>a)(?<y>cac?)")
regextr2(x, "(?<x>a)(?<y>cac?)", capture_groups=TRUE)
gregextr2(x, "(?<x>a)(?<y>cac?)", capture_groups=TRUE)

# substitution - note the different replacement strings:
`gregextr2<-`(x, "(?<x>a)(?<y>cac?)", value=list(c("!", "?"), "#"))
# references to capture groups can only be used in gsub and sub:
gsub2(x, "(?<x>a)(?<y>cac?)", "{$1}{$2}")

regextr2(x, "(?<x>a)(?<y>cac?)") <- "\U0001D554\U0001F4A9"
print(x)  # x was modified 'in-place'


}
\seealso{
The official online manual of \pkg{stringx} at \url{https://stringx.gagolewski.com/}

Related function(s): \code{\link{paste}}, \code{\link{nchar}},
    \code{\link{strsplit}}, \code{\link{gsub2}}
    \code{\link{grepl2}}, \code{\link{gregexpr2}}, \code{\link{gsubstrl}},
}
\author{
\href{https://www.gagolewski.com/}{Marek Gagolewski}
}
