% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.structree.R
\name{plot.structree}
\alias{plot.structree}
\title{Plotting Results of Tree-Structured Clustering}
\usage{
\method{plot}{structree}(x, select = NULL, paths = FALSE,
  result = FALSE, ask = FALSE, xlab = NULL, ylab = NULL,
  main = NULL, lwd = 1, cex.txt = 1, cex.axis = 1, cex.lab = 1,
  cex.main = 1, ...)
}
\arguments{
\item{x}{Object of class \code{\link[structree]{structree}}.}

\item{select}{Elements of the tree component that are plotted; 
if \code{select} is not specified, by default all components are pictured in one plot.}

\item{paths}{If true, the coefficient paths are plotted.}

\item{result}{If true, the resulting partition is displayed.}

\item{ask}{If true, each element chosen by \code{select} is plotted seperately.}

\item{xlab}{Label of x-axis.}

\item{ylab}{Label of y-axis.}

\item{main}{Title of the plot.}

\item{lwd}{Linewidth.}

\item{cex.txt}{Size of the text.}

\item{cex.axis}{Size of the axis.}

\item{cex.lab}{Size of the labels.}

\item{cex.main}{Size of title.}

\item{...}{Further arguments passed to or from other methods.}
}
\description{
Takes a fitted \code{structree} object and plots the results of the tree component of the model.
}
\details{
By default the function pictures the estimated trees against all splits. 
If \code{select=NULL} the trees for all the predictors will be plotted.
}
\examples{
data(rent)

\dontrun{
mod <- structree(nmqm~tr(bez)+tr(bj)+tr(rooms)+badkach0,data=rent,
                 family=gaussian,stop_criterion="CV")

plot(mod, paths=TRUE)
}


}
\references{
Tutz, Gerhard and Berger, Moritz (2018): Tree-structured modelling of categorical predictors in regression, 
Advances in Data Analysis and Classification 12(3), 737-758.

Berger, Moritz and Tutz, Gerhard (2018): Tree-structured clustering in fixed effects models, 
Journal of Computational and Graphical Statistics 27(2), 380-392.
}
\seealso{
\code{\link[structree]{structree}}
}
\author{
Moritz Berger <Moritz.Berger@imbie.uni-bonn.de> \cr \url{http://www.imbie.uni-bonn.de/personen/dr-moritz-berger/}
}
