% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateHeterozygous.r
\name{calculateHeterozygous}
\alias{calculateHeterozygous}
\title{Calculate Heterozygous Loci}
\usage{
calculateHeterozygous(data, debug = FALSE)
}
\arguments{
\item{data}{Data frame containing at least columns 'Sample.Name', 'Marker, and 'Allele*'.}

\item{debug}{logical indicating printing debug information.}
}
\value{
data.frame the original data frame containing additional columns.
}
\description{
Calculates the number of alleles in each marker.
}
\details{
Adds a column 'Heterozygous' to 'data'. Calculates the number of
unique values in the 'Allele*' columns for each marker.
Indicates heterozygous loci as '1' and homozygous as '0'.
Sample names must be unique.
}

