% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{style_file}
\alias{style_file}
\title{Style \code{.R} and/or \code{.Rmd} files}
\usage{
style_file(path, ..., style = tidyverse_style, transformers = style(...))
}
\arguments{
\item{path}{A character vector with paths to files to style.}

\item{...}{Arguments passed on to the \code{style} function.}

\item{style}{A function that creates a style guide to use, by default
\code{\link[=tidyverse_style]{tidyverse_style()}} (without the parentheses). Not used
further except to construct the argument \code{transformers}. See
\code{\link[=style_guides]{style_guides()}} for details.}

\item{transformers}{A set of transformer functions. This argument is most
conveniently constructed via the \code{style} argument and \code{...}. See
'Examples'.}
}
\description{
Performs various substitutions in the files specified.
Carefully examine the results after running this function!
}
\section{Value}{

Invisibly returns a data frame that indicates for each file considered for
styling whether or not it was actually changed.
}

\section{Warning}{

This function overwrites files (if styling results in a change of the
code to be formatted). It is strongly suggested to only style files
that are under version control or to create a backup copy.

We suggest to first style with \code{scope < "tokens"} and inspect and commit
changes, because these changes are guaranteed to leave the abstract syntax
tree (AST) unchanged. See section 'Roundtrip Validation' for details.

Then, we suggest to style with \code{scope = "tokens"} (if desired) and carefully
inspect the changes to make sure the AST is not changed in an unexpected way
that invalidates code.
}

\section{Roundtrip Validation}{

The following section describes when and how styling is guaranteed to
yield correct code.

If the style guide has \code{scope < "tokens"}, no tokens are changed and the
abstract syntax tree (AST) should not change.
Hence, it is possible to validate the styling by comparing whether the parsed
expression before and after styling have the same AST.
This comparison omits comments. styler compares
error if the AST has changed through styling.

Note that with \code{scope = "tokens"} such a comparison is not conducted because
the AST might well change and such a change is intended. There is no way
styler can validate styling, that is why we inform the user to carefully
inspect the changes.

See section 'Warning' for a good strategy to apply styling safely.
}

\examples{
# the following is identical but the former is more convenient:
file <- tempfile("styler", fileext = ".R")
enc::write_lines_enc("1++1", file)
style_file(file, style = tidyverse_style, strict = TRUE)
style_file(file, transformers = tidyverse_style(strict = TRUE))
enc::read_lines_enc(file)
unlink(file)
}
\seealso{
Other stylers: \code{\link{style_dir}},
  \code{\link{style_pkg}}, \code{\link{style_text}},
  \code{\link{styler_addins}}
}
