% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/CTTsub.RegOnSub.r
\name{CTTsub.RegOnSub}
\alias{CTTsub.RegOnSub}
\title{This function computes subscores based on the observed subscore in classical test theory (CTT).}
\usage{
CTTsub.RegOnSub(test.data)
}
\arguments{
\item{test.data}{A list that contains datasets of all subtests and the whole test,
which can be obtained using function 'data.prep'.}
}
\value{
A list of objects that include both test information and subscores: \cr
        (1) "subscore.information" - It contains test information of both subtests
                                     and the total test, such as mean of subscores and total score, reliability, and PRMSE.\cr
        (2) "subscore.original" - It contains original subscores and total score.\cr
        (3) "subscore.RegOnSub" - It contains subscores that are estimated based on the observed subscore.
}
\description{
This function computes CTT subscores based on the observed subscore, using the methods introduced in
Haberman (2008), Haberman et al. (2009), and Sinharay (2010), which returns:\cr
	(1) Original Observed subscore; \cr
	(2) The true subscore is estimated based on the observed subscore;\cr
}
\examples{
CTTsub.RegOnSub(test.data)
}

