% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RegOnSub.r
\name{RegOnSub}
\alias{RegOnSub}
\title{Computing subscores using Haberman's method based on observed subscores.}
\usage{
RegOnSub(test.data)
}
\arguments{
\item{test.data}{A list that contains subscale responses and the total test responses. It 
can be obtained using the function 'data.prep'.}
}
\value{
\item{summary}{Summary of obtained subscores (e.g., mean, sd).}
\item{PRMSE}{PRMSEs of obtained subscores (for Haberman's methods only).}
\item{subscore.original}{Original subscores and total score.}
\item{subscore.RegOnSub}{Subscores that are estimated based on the observed subscore.}
}
\description{
This function estimate true subscores based on observed subscores, 
using the method introduced by Haberman (2008).
}
\examples{
# Transfering scored response data to the requried list format
test.data<-data.prep(scored.data,c(3,15,15,20))
  
#Estimate true subscores using Hamerman's method based on observed subscores     
RegOnSub(test.data) 
       
RegOnSub(test.data)$summary
RegOnSub(test.data)$PRMSE
RegOnSub(test.data)$subscore.RegOnSub
}
\references{
{
Haberman, S. J. (2008). 
"When can subscores have value?."
 Journal of Educational and Behavioral Statistics, 33(2), 204-229. 
}
}

