package weka.subspaceClusterer;

import i9.subspace.base.Cluster;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;

public class SubspaceClusterTools {

	public static ArrayList<Cluster> getClusterList(File file, int m_dimensions) {

		ArrayList<Cluster> result = new ArrayList<Cluster>();

		try {
			FileReader fileReader = new FileReader(file);
			LineNumberReader reader = new LineNumberReader(fileReader);
			String line = reader.readLine(); // drop header line
			line = reader.readLine();
			while (line != null) {
				StringTokenizer token = new StringTokenizer(line);
				int value;
				boolean[] subspace = new boolean[m_dimensions];
				List<Integer> objects = new LinkedList<Integer>();

				for (int i = 0; i < m_dimensions; i++) {
					value = Integer.valueOf(token.nextToken(" ")).intValue();
					if (value == 1)
						subspace[i] = true;
				}
				int size = Integer.valueOf(token.nextToken(" ")).intValue();
				for (int i = 0; i < size; i++) {
					value = Integer.valueOf(token.nextToken(" ")).intValue();
					objects.add(value);
				}
				result.add(new Cluster(subspace, objects));
				line = reader.readLine();
			}

		} catch (IOException e) {
			e.printStackTrace();
		}

		return result;
	}
	
}
