% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/breast.R
\docType{data}
\name{breast}
\alias{breast}
\title{Survival after breast cancer surgery}
\format{
A \code{data.frame} with 2663 rows and 11 variables:
\describe{
\item{entrytime}{Chronological time of entry of patient into study/time of surgery (numeric)}
\item{survtime}{Time from entry until failure of patient (numeric)}
\item{censorid}{Censoring indicator (0 - right censored, 1 - observed) (integer)}
\item{unit}{Unit number at which patient received treatment (integer)}
\item{var1-7}{Covariates associated with patient (factor)}
}
}
\source{
Based on trial data from the European Organisation for Research and
Treatment of Cancer, \url{https://www.eortc.org/}
}
\usage{
breast
}
\description{
Data about patient survival after their breast cancer surgery procedure
performed at one of the 15 units participating in a cancer treatment study.
The data is based on a trial performed at the European Organisation for
Research and Treatment of Cancer (EORTC).
}
\examples{
#Determine the estimated arrival rate for all units in the data
arrival_rate(breast)

#Plot Quality Control charts for unit 11 in the study
library(survival)
phmodbreast <- coxph(Surv(survtime, censorid) ~ . - entrytime - unit ,
data = breast)
glmmodbreast <- glm((survtime <= 36) & (censorid == 1) ~ . - entrytime - unit,
 data = breast, family = binomial(link = "logit"))

par(mfrow = c(1, 3))
p1 <- plot(cgr_cusum(data = subset(breast, unit == 11),  coxphmod = phmodbreast)) +
ggtitle("CGR-CUSUM")
p2 <- plot(bk_cusum(data = subset(breast, unit == 11),  coxphmod = phmodbreast,
 theta = log(2))) + ggtitle("BK-CUSUM")
p3 <- plot(bernoulli_cusum(data = subset(breast, unit == 11), followup = 36,
 glmmod = glmmodbreast, theta = log(2))) + ggtitle("Bernoulli CUSUM")
p4 <- plot(funnel_plot(data = breast, glmmod = glmmodbreast, followup = 36 )) +
ggtitle("Funnel plot")

if(require("gridExtra")){
 grid.arrange(p1, p2, p3, p4, nrow = 2)
}

}
\keyword{datasets}
