% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/define_crit1_cutoff.R
\name{define_crit1_cutoff}
\alias{define_crit1_cutoff}
\title{Define cut-off value for first SG criterion}
\usage{
define_crit1_cutoff(data_sessions, tx_start_var_name, tx_end_var_name,
  data_item = NULL, reliability = NULL)
}
\arguments{
\item{data_sessions}{A dataset in wide format with values for pre _s0 and post treatment _end}

\item{tx_start_var_name}{String, variable name of the pretreatment scores}

\item{tx_end_var_name}{String, variable name of the postreatment scores}

\item{data_item}{A dataset in item-by-item scores for the SG measure}

\item{reliability}{Numeric, between 0 and 1 indicating reliability of the scale.}
}
\value{
A list with all calculated variables using modified formula for RCI including cut-off
}
\description{
Define the cut-off value for first sudden gains criterion using a modified reliable change index (RCI) formula.
}
\examples{
# Define cut-off value for first SG criterion
# In this example the reliability is specified and not calculated from item-by-item data
define_crit1_cutoff(data_sessions = sgdata,
                    data_item = NULL,
                    tx_start_var_name = "bdi_s0",
                    tx_end_var_name = "bdi_s12",
                    reliability = 0.931)
}
\references{
Jacobson, N. S., & Truax, P. A. (1991). Clinical significance: A statistical approach to defining meaningful change in psychotherapy research. Journal of Consulting and Clinical Psychology, 59 (1), 12-19. \url{https://doi.org/10.1037/0022-006X.59.1.12}.

Stiles et al. (2003). Early sudden gains in psychotherapy under routine clinic conditions: Practice-based evidence. Journal of Consulting and Clinical Psychology, 71 (1), 14-21. \url{https://doi.org/10.1037/0022-006X.71.1.14}.
}
