% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descr.R
\name{descr}
\alias{descr}
\title{Univariate Statistics for Numerical Data}
\usage{
descr(
  x,
  var = NULL,
  stats = st_options("descr.stats"),
  na.rm = TRUE,
  round.digits = st_options("round.digits"),
  transpose = st_options("descr.transpose"),
  order = "sort",
  style = st_options("style"),
  plain.ascii = st_options("plain.ascii"),
  justify = "r",
  headings = st_options("headings"),
  display.labels = st_options("display.labels"),
  split.tables = 100,
  weights = NA,
  rescale.weights = FALSE,
  ...
)
}
\arguments{
\item{x}{A numerical vector or a data frame.}

\item{var}{Unquoted expression referring to a specific column in \code{x}.
Provides support for piped function calls (e.g.
\code{my_df \%>\% descr(my_var)}.}

\item{stats}{Character. Which stats to produce. Either \dQuote{all} (default),
\dQuote{fivenum}, \dQuote{common} (see \emph{Details}), or a selection of :
\dQuote{mean}, \dQuote{sd}, \dQuote{min}, \dQuote{q1}, \dQuote{med},
\dQuote{q3}, \dQuote{max}, \dQuote{mad}, \dQuote{iqr}, \dQuote{cv},
\dQuote{skewness}, \dQuote{se.skewness}, \dQuote{kurtosis},
\dQuote{n.valid}, and \dQuote{pct.valid}. Can be set globally via
\code{\link{st_options}}, option \dQuote{descr.stats}.}

\item{na.rm}{Logical. Argument to be passed to statistical functions. 
Defaults to \code{TRUE}.}

\item{round.digits}{Numeric. Number of significant digits to display. 
Defaults to \code{2}. Can be set globally with \code{\link{st_options}}.}

\item{transpose}{Logical. Make variables appears as columns, and stats as
rows. Defaults to \code{FALSE}. Can be set globally with
\code{\link{st_options}}, option \dQuote{descr.transpose}.}

\item{order}{Character. When analyzing more than one variable, this parameter
determines how to order variables. Valid values are \dQuote{sort} (or
simply \dQuote{s}), \dQuote{preserve} (or \dQuote{p}), or a vector
containing all variable names in the desired order. Defaults to
\dQuote{sort}.}

\item{style}{Character. Style to be used by \code{\link[pander]{pander}}. One
of \dQuote{simple} (default), \dQuote{grid}, \dQuote{rmarkdown}, or
\dQuote{jira}. Can be set globally with \code{\link{st_options}}.}

\item{plain.ascii}{Logical. \code{\link[pander]{pander}} argument; when
\code{TRUE} (default), no markup characters will be used (useful when
printing to console). If \code{style = 'rmarkdown'} is specified, value
is set to \code{FALSE} automatically. Can be set globally using
\code{\link{st_options}}.}

\item{justify}{Character. Alignment of numbers in cells; \dQuote{l} for left,
\dQuote{c} for center, or \dQuote{r} for right (default). Has no effect on 
\emph{html} tables.}

\item{headings}{Logical. Set to \code{FALSE} to omit heading section. Can be
set globally via \code{\link{st_options}}. \code{TRUE} by default.}

\item{display.labels}{Logical. Show variable / data frame labels in heading
section. Defaults to \code{TRUE}. Can be set globally with
\code{\link{st_options}}.}

\item{split.tables}{Character. \code{\link[pander]{pander}} argument that
specifies how many characters wide a table can be. \code{100} by default.}

\item{weights}{Numeric. Vector of weights having same length as \emph{x}.
\code{NA} (default) indicates that no weights are used.}

\item{rescale.weights}{Logical. When set to \code{TRUE}, a global constant is
apply to make the total count equal \code{nrow(x)}. \code{FALSE} by default.}

\item{\dots}{Additional arguments passed to \code{\link[pander]{pander}} or
\code{\link[base]{format}}.}
}
\value{
An object having classes \dQuote{\emph{matrix}} and
  \dQuote{\emph{summarytools}} containing the statistics, with extra
  attributes used by \code{\link{print}} method and \link{view} function.
}
\description{
Calculates mean, sd, min, Q1*, median, Q3*, max, MAD, IQR*, CV, 
skewness*, SE.skewness*, and kurtosis* on numerical vectors. (*) Not 
available when using sampling weights.
}
\examples{
data("exams")

# All stats for all numerical variabls
descr(exams)

# Only common statistics
descr(exams, stats = "common")

# Arbitrary selection of statistics, transposed
descr(exams, stats = c("mean", "sd", "min", "max"), transpose = TRUE)

# Rmarkdown-ready
descr(exams, plain.ascii = FALSE, style = "rmarkdown")

# Grouped statistics
data("tobacco")
with(tobacco, stby(BMI, gender, descr))

# Grouped statistics, transposed
with(tobacco, stby(BMI, age.gr, descr, stats = "common", transpose = TRUE))

\dontrun{
# Show in Viewer (or browser if not in RStudio)
view(descr(exams))

# Save to html file with title
print(descr(exams),
      file = "descr_exams.html", 
      report.title = "BMI by Age Group",
      footnote = "<b>Schoolyear:</b> 2018-2019<br/><b>Semester:</b> Fall")

}

}
\author{
Dominic Comtois, \email{dominic.comtois@gmail.com}
}
\keyword{univar}
