% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summclust_fixest.R
\name{summclust.fixest}
\alias{summclust.fixest}
\title{Compute Influence and Leverage Metrics for objects of type \code{fixest}}
\usage{
\method{summclust}{fixest}(
  obj,
  cluster,
  params,
  absorb_cluster_fixef = TRUE,
  type = "CRV3",
  ...
)
}
\arguments{
\item{obj}{An object of type fixest}

\item{cluster}{A clustering vector}

\item{params}{A character vector of variables for which leverage statistics
should be computed. If NULL, leverage statistics will be computed for all
k model covariates}

\item{absorb_cluster_fixef}{TRUE by default. Should the cluster fixed
effects be projected out? This increases numerical stability and
decreases computational costs}

\item{type}{"CRV3" or "CRV3J" following MacKinnon, Nielsen & Webb}

\item{...}{other function arguments passed to 'vcov'}
}
\value{
An object of type \code{summclust}, including
a CRV3 variance-covariance estimate as described in
MacKinnon, Nielsen & Webb (2022)

\item{coef_estimates}{The coefficient estimates of the linear model.}
\item{vcov}{A CRV3 or CRV3J variance-covariance matrix estimate
as described in MacKinnon, Nielsen & Webb (2022)}
\item{leverage_g}{A vector of leverages.}
\item{leverage_avg}{The cluster leverage.}
\item{partial_leverage}{The partial leverages.}
\item{coef_var_leverage_avg}{Coefficient of Variation for the leverage
statistic}
\item{coef_var_leverage_g}{Coefficient of Variation for the Partial
Leverage Statistics}
\item{coef_var_N_G}{Coefficient of Variation for the Cluster Sizes.}
\item{beta_jack}{The jackknifed' leave-on-cluster-out
regression coefficients.}
\item{params}{The input parameter vector 'params'.}
\item{N_G}{The number of clusters- }
\item{call}{The \code{summclust()} function call.}
\item{cluster}{The names of the clusters.}
}
\description{
Compute influence and leverage metrics for clustered inference
based on the Cluster Jackknife as described in MacKinnon, Nielsen & Webb
(2022) for objects of type \code{fixest}.
}
\examples{

library(summclust)
data(mtcars)
mtcars

fit <- lm(mpg ~ cyl + disp + hp, data = mtcars)
summ <- summclust(fit, params = ~cyl + disp, cluster = ~carb)
summary(summ)
tidy(summ)
plot(summ)

}
\references{
MacKinnon, James G., Morten Ørregaard Nielsen, and Matthew D. Webb.
"Leverage, influence, and the jackknife in clustered regression models:
Reliable inference using summclust."
arXiv preprint arXiv:2205.03288 (2022).
}
