% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CountVectorizer.R
\docType{data}
\name{CountVectorizer}
\alias{CountVectorizer}
\title{Count Vectorizer}
\format{\code{\link{R6Class}} object.}
\usage{
CountVectorizer
}
\description{
Creates CountVectorizer Model.
Given a list of text, it generates a bag of words model and returns a data frame consisting of BOW features.
}
\section{Usage}{

For usage details see \bold{Methods, Arguments and Examples} sections.
\preformatted{
bst = CountVectorizer$new(min_df=1, max_df=1, max_features=1)
bst$fit(sentences)
bst$fit_transform(sentences)
bst$transform(sentences)
}
}

\section{Methods}{

\describe{
    \item{\code{$new()}}{Initialise the instance of the vectorizer}
    \item{\code{$fit()}}{creates a memory of bag of words}
    \item{\code{$transform()}}{based on encodings learned in \code{fit} method, return a bag of words matrix }
    \item{\code{$fit_transform()}}{simultaneouly fits and transform words and returns bag of words of matrix}
}
}

\examples{
df <- data.frame(sents = c('i am alone in dark.','mother_mary a lot',
                           'alone in the dark?',
                           'many mothers in the lot....'))

# fits and transforms on the entire data in one go
bw <- CountVectorizer$new(min_df = 0.3)
tf_features <- bw$fit_transform(df$sents)

# fit on entire data and do transformation in train and test
bw <- CountVectorizer$new()
bw$fit(df$sents)
tf_features <- bw$transform(df$sents)
}
\keyword{datasets}
