% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise.R
\name{autoplot.pairwise}
\alias{autoplot.pairwise}
\alias{plot.pairwise}
\title{Plotting method for pairwise objects.}
\usage{
autoplot.pairwise(object, ...)

\method{plot}{pairwise}(x, y, ...)
}
\arguments{
\item{object}{A \code{\link{pairwise}} object.}

\item{...}{Additional arguments passed to the plotting geom.}

\item{x}{A \code{pairwise} object.}

\item{y}{Ignored, required for compatibility with the \code{plot()} generic.}
}
\description{
Plotting method for pairwise objects.
}
\details{
This function requires an optional dependency: \code{\link[ggplot2:ggplot2-package]{ggplot2}}.
When this package is installed, calling \code{autoplot()} or \code{plot} on a \code{pairwise} object will
generate a plot of the pairwise comparisons. The plot will show the differences between the
groups, with error bars representing the confidence intervals. The x-axis will be labeled with
the type of confidence interval used and the values of the differences, and the y-axis will be
labeled with the groups being compared. A dashed line at 0 is included to help visualize the
differences.
}
\examples{
if (require(ggplot2)) {
  # generate the plot immediately
  pairwise(lm(mpg ~ factor(am) + disp, data = mtcars), plot = TRUE)

  # or save the object and plot it later
  p <- pairwise(lm(mpg ~ factor(am) + disp, data = mtcars))
  plot(p)
}
}
