% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suppdata.R
\name{suppdata}
\alias{suppdata}
\alias{suppdata.character}
\alias{suppdata.ft_data}
\alias{suppdata.ft}
\title{Download supplementary materials from journals}
\usage{
suppdata(
  x,
  si,
  from = c("auto", "plos", "wiley", "science", "proceedings", "figshare",
    "esa_data_archives", "esa_archives", "biorxiv", "epmc", "peerj", "copernicus",
    "jstatsoft"),
  save.name = NA,
  dir = NA,
  cache = TRUE,
  vol = NA,
  issue = NA,
  list = FALSE,
  timeout = 10
)

\method{suppdata}{character}(
  x,
  si,
  from = c("auto", "plos", "wiley", "science", "proceedings", "figshare",
    "esa_data_archives", "esa_archives", "biorxiv", "epmc", "peerj", "copernicus",
    "jstatsoft"),
  save.name = NA,
  dir = NA,
  cache = TRUE,
  vol = NA,
  issue = NA,
  list = FALSE,
  timeout = 10
)

\method{suppdata}{ft_data}(
  x,
  si,
  from = c("auto"),
  save.name = NA,
  dir = NA,
  cache = TRUE,
  vol = NA,
  issue = NA,
  list = FALSE,
  timeout = 10
)

\method{suppdata}{ft}(
  x,
  si,
  from = c("auto"),
  save.name = NA,
  dir = NA,
  cache = TRUE,
  vol = NA,
  issue = NA,
  list = FALSE,
  timeout = 10
)
}
\arguments{
\item{x}{One of: vector of DOI(s) of article(s) (a
\code{character}), output from \code{fulltext}'s
\code{\link[fulltext]{ft_get}}, or output from
\code{fulltext}'s \code{\link[fulltext]{ft_search}}. Note: if
using ESA journal, you can *only* use the ESA-specific article
code (e.g., E092-201).}

\item{si}{number of the supplementary information (SI) to be
downloaded (1, 2, 3, etc.), or (for ESA, Science, and
Copernicus journals) the name of the supplement (e.g.,
"S1_data.csv"). Can be a \code{character} or \code{numeric}.}

\item{from}{Publisher of article (\code{character}). The default
(\code{auto}) uses crossref (\code{\link[rcrossref]{cr_works}})
to detect the journal's publisher. Specifying the journal can
somewhat speed up your download, or be used to force a download
from EPMC (see details). You *must* specify if downloading from
an ESA journal (\code{esa_data_archives},
\code{esa_archives}). You can only use this argument if
\code{x} is a vector of DOI(s). Must be one of: \code{auto}
(i.e., auto-detect journal; default), \code{plos},
\code{wiley}, \code{science}, \code{proceedings},
\code{figshare}, \code{esa_data_archives}, \code{esa_archives},
\code{biorxiv}, \code{epmc}, \code{peerj}, \code{copernicus},
(Data)\code{dryad}), \code{mdpi}, or \code{jstatsoft}.}

\item{save.name}{a name for the file to download
(\code{character}). If \code{NA} (default) this will be a
combination of the DOI and SI number}

\item{dir}{directory to save file to (\code{character}). If
\code{NA} (default) this will be a temporary directory created
for your files}

\item{cache}{if \code{TRUE} (default), the file won't be downloaded
again if it already exists (in a temporary directory creates,
or your chosen \code{dir})}

\item{vol}{Article volume (Proceedings journals only;
\code{numeric})}

\item{issue}{Article issue (Proceedings journals only;
\code{numeric})}

\item{list}{if \code{TRUE}, print all files within a zip-file
downloaded from EPMC (default: FALSE). This is *very* useful if
using EPMC (see details)}

\item{timeout}{how long to wait for successful download (default 10
seconds)}
}
\description{
Put a call to this function where you would put a file-path - everything 
is cached by default, so you don't have to worry about multiple downloads 
in the same session.
}
\details{
The examples probably give the best indication of how to
use this function. In general, just specify the DOI of the article
you want to download data from, and the number of the supplement
you want to download (1, 5, etc.). ESA journals don't use DOIs
(give the article code; see below), and Proceedings, Science, and
ESA journals need you to give the filename of the supplement to
download. For Figshare articles, you can give either the number or
the name. The file extensions (suffixes) of files are returned as
\code{suffix} attributes (see first example), which may be useful
if you don't know the format of the file you're downloading.

For any DOIs not recognised (and if asked) the European PubMed
Central API is used to look up articles. What this database calls a
supplementary file varies by publisher; often they will simply be
figures within articles, but we (obviously) have no way to check
this at run-time. I strongly recommend you run any EPMC calls with
\code{list=TRUE} the first time, to see the filenames that EPMC
gives supplements, as these also often vary from what the authors
gave them. This may actually be a 'feature', not a 'bug', if you're
trying to automate some sort of meta-analysis.

Below is a list of all the publishers this supports, and examples
of articles from them.

\describe{
\item{auto}{Default. Use a cross-ref search
(\code{\link[rcrossref:cr_works]{cr_works}}) on the DOI to
determine the publisher.}
\item{plos}{Public Library of Science journals (e.g., PLoS One;
\url{https://journals.plos.org/plosone/article?id=10.1371/journal.pone.0126524})}
\item{wiley}{Wiley journals (e.g.,
\url{https://onlinelibrary.wiley.com/doi/10.1111/ele.12289/abstract})}
\item{science}{Science magazine (e.g.,
\url{https://www.sciencemag.org/content/345/6200/1041.short})}
\item{proceedings}{Royal Society of London journals (e.g.,
\url{https://rspb.royalsocietypublishing.org/content/282/1814/20151215}). Requires
\code{vol} and \code{issue} of the article.}
\item{figshare}{Figshare (e.g.,
\url{https://doi.org/10.6084/m9.figshare.979288.v1})}
\item{esa_data_archives & esa_data}{You must give article codes,
not DOIs, for these, which you can find on the article itself. An
ESA Data Archive paper - not to be confused with an ESA Archive,
which is the supplement to an ESA paper. The distinction seems less
crazy once you're reading the paper - if it only describes a
dataset, it's an \code{esa_archive} paper, else it's an
\code{esa_data_archive}. For example,
\url{http://www.esapubs.org/archive/ecol/E092/201/default.htm} is
an \code{esa_data_archive} whose article code is E092-201-D1;
\url{http://esapubs.org/Archive/ecol/E093/059/default.htm} is a
\code{esa_archive} whose code is E093-059-D1.}
\item{biorxiv}{Load from bioRxiv (e.g.,
\url{https://biorxiv.org/content/early/2015/09/11/026575})} 
\item{epmc}{Look up an article on the Europe PubMed Central, and
then download the file using their supplementary materials API
(\url{https://europepmc.org/restfulwebservice}). See comments above
in 'notes' about EPMC.}
\item{peerj}{PeerJ journals (e.g., \url{https://doi.org/10.7717/peerj.3006})
and PeerJ Preprints (e.g., \url{https://doi.org/10.7287/peerj.preprints.26561v1})}
\item{copernicus}{Copernicus Publications journals (e.g., 
\url{https://doi.org/10.5194/bg-14-1739-2017}), see
\url{https://publications.copernicus.org/open-access_journals/open_access_journals_a_z.html}
for a full list of journals. Only one supplemental is supported,
which can be a zip archive or a PDF file. 
A numeric \code{si} parameter must be \code{1} to download the 
whole archive, which is saved using Copernicus naming scheme
(<journalname>-<volume>-<firstpage>-<year>-supplement.zip)
and \code{save.name} is ignored, or to download the PDF.
If \code{si} matches the name of the supllemental archive (i.e. uses the
Copernics naming scheme), then the suppdata archive is not unzipped.
\code{si} may be the name of a file in that 
archive, so only that file is extracted and saved to \code{save.name}.}
}
}
\note{
Make sure that the article from which you're attempting to
    download supplementary materials *has* supplementary
    materials. 404 errors and 'file not found' errors can result
    from such cases.
}
\examples{
\donttest{
#Put the function wherever you would put a file path
crabs <- read.csv(suppdata("10.6084/m9.figshare.979288", 2))

#View the suffix (file extension) of downloaded files
# - note that not all files are uploaded/stored with useful file extensions!
suppdata("10.6084/m9.figshare.979288", 2)
attr(suppdata("10.6084/m9.figshare.979288", 2), "suffix")

#ESA data papers and regular articles *must* be marked
fungi <- read.csv(suppdata("E093-059", "myco_db.csv",
                                        "esa_archives"))
mammals <- read.csv(suppdata("E092-201", "MCDB_communities.csv",
                                            "esa_data_archives"))

epmc.fig <- suppdata("10.1371/journal.pone.0126524",
                       "pone.0126524.s002.jpg", "epmc")
#...note this 'SI' is not actually an SI, but rather an image from the paper.

copernicus.csv <- suppdata("10.5194/bg-14-1739-2017",
                           "Table S1 v2 UFK FOR_PUBLICATION.csv",
                           save.name = "data.csv")
#...note this 'SI' is not an SI but the name of a file in the supplementary information archive.
}
# (examples not run on CRAN to avoid downloading files repeatedly)
}
\author{
Will Pearse (\email{will.pearse@usu.edu}) and Scott
    Chamberlain (\email{myrmecocystus@gmail.com})
}
