% Generated by roxygen2 (4.0.1): do not edit by hand
\name{ci}
\alias{ci}
\alias{ci.survfit}
\title{Confidence intervals for survival curves}
\source{
The function is loosely based on \code{km.ci::km.ci}.
}
\usage{
ci(x, ...)

\method{ci}{survfit}(x, ..., CI = c("0.95", "0.9", "0.99"), how = c("point",
  "nair", "hall"), trans = c("log", "lin", "asin"), tL = NULL, tU = NULL)
}
\arguments{
\item{x}{An object of class \code{survfit}}

\item{...}{Additional arguments (not implemented)}

\item{CI}{Confidence intervals. As the function currently relies on lookup
tables, currently only 95\% (the default), 90\% and 99\% are supported.}

\item{how}{Method to use for confidence interval.
\cr
\code{point} (the default) uses pointwise confirence intervals.
\cr
The alternatives use confidence \emph{bands} (see details).}

\item{trans}{Transformation to use.
\cr
The default is \code{trans="log"}.
\cr
Also supported are linear and arcsine-square root transformations.}

\item{tL}{\bold{L}ower time point. Used in construction of confidence bands.}

\item{tU}{\bold{U}pper time point. Used in construction of confidence bands.}
}
\value{
A \code{survfit} object. The \code{upper} and \code{lower}
elements in the list (representing confidence intervals)
are modified from the original.
\cr
Other elements will also be shortened if the time range under consideration has been
reduced from the original.
}
\description{
Confidence intervals for survival curves


}
\details{
In the equations below
\deqn{\sigma^2_s(t) = \frac{\hat{V}[\hat{S}(t)]}{\hat{S}^2(t)} }{
       sigma^2(t) = V[S(t)]/[S(t)]^2}
Where \eqn{\hat{S}(t) }{S(t)} is the Kaplan-Meier survival estimate and
\eqn{\hat{V}[\hat{S}(t)]}{V[S(t)]} is Greenwood's estimate of its
variance.
\cr
The \bold{pointwise} confidence intervals are valid for \emph{individual}
times, e.g. \code{median} and \code{\link{quantile}} values.
When plotted and joined for multiple points they tend to
be narrower than the \emph{bands} described below.
Thus they tend to exaggerate the impression of certainty
when used to plot confidence intervals for a time range.
They should not be interpreted as giving the intervals
within which the \emph{entire} survival function lies.
\cr
For a given significance level \eqn{\alpha}{alpha},
they are calculated using the standard normal distribution \eqn{Z}
as follows:

\itemize{

\item linear
      \deqn{\hat{S}(t) \pm Z_{1- \alpha} \sigma (t) \hat{S}(t)}{
            S(t)+- Z(1-alpha) sigma(t) S(t)}

\item log transform
      \deqn{ [ \hat{S}(t)^{\frac{1}{\theta}}, \hat{S}(t)^{\theta} ] }{
             [S(t)^(1/theta), S(t)^theta]}
where
\deqn{ \theta = \exp{ \frac{Z_{1- \alpha} \sigma (t)}{ \log{\hat{S}(t)}}} }{
       theta = exp ( Z(1-alpha)sigma(t) / log(S(t)) )}

\item arcsine-square root transform
\cr
upper:
\cr
\deqn{ \sin^2(\max[0, \arcsin{\sqrt{\hat{S}(t)}} -
  \frac{Z_{1- \alpha}\sigma(t)}{2}
  \sqrt{ \frac{\hat{S}(t)}{1-\hat{S}(t)}}]) }{
      sin^2(max[0, arcsin S(t)^0.5 - Z(1-alpha)sigma(t)/2 (S(t)/1-S(t))^0.5])}
lower:
\deqn{ \sin^2(\min[\frac{\pi}{2}, \arcsin{\sqrt{\hat{S}(t)}} +
  \frac{Z_{1- \alpha}\sigma(t)}{2}
  \sqrt{ \frac{\hat{S}(t)}{1-\hat{S}(t)}}]) }{
      sin^2(min[pi/2, arcsin S(t)^0.5  + Z(1-alpha)sigma(t)/2 (S(t)/1-S(t))^0.5])}

}

Confidence \bold{bands} give the values within which the survival function
falls within a \emph{range} of timepoints.
\cr \cr
The time range under consideration is given so that
\eqn{t_l \geq t_{min}}{tL >= min(t)}, the minimum or lowest event time and
\eqn{t_u \leq t_{max}}{tU <= max(t)}, the maximum or largest event time.
\cr
For a sample size \eqn{n} and \eqn{0 < a_l < a_u <1}:
\deqn{a_l = \frac{n\sigma^2_s(t_l)}{1+n\sigma^2_s(t_l)}}{
a_l = n*sigma^2(t_l) / [1+n*sigma^2(t_l)]}
\deqn{a_u = \frac{n\sigma^2_s(t_u)}{1+n\sigma^2_s(t_u)}}{
a_u = n*sigma^2(t_u) / [1+n*sigma^2(t_u)]}

For the \bold{Nair} or \bold{equal precision} (\bold{EP}) confidence bands,
we begin by obtaining the relevant
confidence coefficient \eqn{c_{\alpha}}{c[alpha]}. This is obtained from
the upper \eqn{\alpha}{a}-th fractile of the random variable
\deqn{U = \sup{|W^o(x)\sqrt{[x(1-x)]}|, \quad a_l \leq x \leq a_u}}{
U = sup{ |W(x)[x(1-x)]^0.5|, a_l <= x <= a_u} }
Where \eqn{W^o}{W} is a standard Brownian bridge.
\cr
The intervals are:

\itemize{

\item linear
\deqn{ \hat{S}(t) \pm c_{\alpha} \sigma_s(t) \hat{S}(t)}{
       S(t)+- c[alpha] sigma(t) S(t)}

\item log transform (the default)
\deqn{ [ \hat{S}(t)^{\frac{1}{\theta}}, \hat{S}(t)^{\theta} ] }{
[S(t)^(1/theta), S(t)^theta]}
where
\deqn{ \theta = \exp{ \frac{c_{\alpha} \sigma_s(t)}{ \log{\hat{S}(t)}}} }{
       theta = exp ( c[alpha]*sigma(t) / log(S(t)) )}

\item arcsine-square root transform
\cr \cr
upper:
\deqn{ \sin^2(\max[0, \arcsin{\sqrt{\hat{S}(t)}}
  - \frac{c_{\alpha}\sigma_s(t)}{2}
  \sqrt{ \frac{\hat{S}(t)}{1-\hat{S}(t)}}]) }{
sin^2( max[0, arcsin S(t)^0.5 - c[alpha]*sigma(t)/2 (S(t)/1-S(t))^0.5])}
lower:
\deqn{ \sin^2(\min[\frac{\pi}{2}, \arcsin{\sqrt{\hat{S}(t)}}
  + \frac{c_{\alpha}\sigma_s(t)}{2}
  \sqrt{ \frac{\hat{S}(t)}{1-\hat{S}(t)}}]) }{
sin^2( min[pi/2, arcsin S(t)^0.5 - c[alpha]*sigma(t)/2 (S(t)/1-S(t))^0.5])}

}

For the \bold{Hall-Wellner} bands the confidence coefficient
\eqn{k_{\alpha}}{k[alpha]}
is obtained from the upper \eqn{\alpha}{a}-th fractile of a
Brownian bridge.
\cr
In this case \eqn{t_l} can be \eqn{=0}.
\cr
The intervals are:

\itemize{

\item linear
\deqn{ \hat{S}(t) \pm
k_{\alpha} \frac{1+n\sigma^2_s(t)}{\sqrt{n}} \hat{S}(t)}{
S(t)+- k[alpha] [1+n*sigma^2(t)]*S(t) / n^0.5 }

\item log transform
\deqn{ [ \hat{S}(t)^{\frac{1}{\theta}}, \hat{S}(t)^{\theta} ] }{
[S(t)^(1/theta), S(t)^theta]}
where
\deqn{ \theta = \exp{ \frac{k_{\alpha}[1+n\sigma^2_s(t)]}{
   \sqrt{n}\log{\hat{S}(t)}}} }{
theta = exp ( k[alpha]*[1+n*sigma^2(t)] / n^0.5 * log(S(t)) )}

\item arcsine-square root transform
\cr
upper:
\deqn{ \sin^2(\max[0, \arcsin{\sqrt{\hat{S}(t)}}
  - \frac{k_{\alpha}[1+n\sigma_s(t)]}{2\sqrt{n}}
  \sqrt{ \frac{\hat{S}(t)}{1-\hat{S}(t)}}]) }{
sin^2( max[0, arcsin S(t)^0.5 - k[alpha]*[1+n*sigma^2(t)]/(2*n^0.5) (S(t)/1-S(t))^0.5])}
lower:
\deqn{ \sin^2(\min[\frac{\pi}{2}, \arcsin{\sqrt{\hat{S}(t)}}
  + \frac{k_{\alpha}[1+n\sigma^2_s(t)]}{2\sqrt{n}}
  \sqrt{ \frac{\hat{S}(t)}{1-\hat{S}(t)}}]) }{
sin^2( min[pi/2, arcsin S(t)^0.5 - k[alpha]*[1+n*sigma^2(t)]/(2*n^0.5) (S(t)/1-S(t))^0.5])}

}
}
\note{
\itemize{
  \item For the Nair and Hall-Wellner bands, the function currently
        relies on the lookup tables in \code{package:km.ci}.
  \item Generally, the arcsin-square root transform has the best coverage properties.
  \item All bands have good coverage properties for samples as small as \eqn{n=20},
        except for the \bold{Nair} / \bold{EP} bands with a linear transformation,
        which perform poorly when \eqn{n < 200}.
}
}
\examples{
data(bmt, package="KMsurv")
b1 <- bmt[bmt$group==1, ] # ALL patients
s1 <- survfit(Surv(t2, d3) ~ 1, data=bmt[bmt$group==1, ])
ci(s1, how="nair", trans="lin", tL=100, tU=600)
s2 <- survfit(Surv(t2, d3) ~ group, data=bmt)
ci(s2, CI="0.99", how="point", trans="asin", tL=100, tU=600)
}
\references{
Nair V, 1984.
Confidence bands for survival functions with censored data: a comparative study.
\emph{Technometrics}. \bold{26}(3):265-75.
\href{http://www.jstor.org/stable/1267553}{JSTOR}.

Hall WJ, Wellner JA, 1980.
Confidence bands for a survival curve from censored data.
\emph{Biometrika}. \bold{67}(1):133-43.
\href{http://www.jstor.org/stable/2335326}{JSTOR}.

Examples are from:
\bold{K&M}.
Section 4.4, pg 111.
}
\seealso{
\code{\link{sf}}

\code{\link{quantile}}
}

