% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/survPMF.R
\name{survPMF}
\alias{survPMF}
\title{Computes marginal and joint probability mass function from marginal and joint survival probabilities.}
\usage{
survPMF(bivarSurf)
}
\arguments{
\item{bivarSurf}{A matrix containing the marginal and joint survival probabilities. The first column is the marginal survival probability corresponding to variable \code{X}. The first row is the marginal survival probability corresponding to variable \code{Y}. The rest of the matrix contains the joint survival probabilities. The row names of \code{bivarSurf} are ordered \code{X} values. The column names of \code{bivarSurf} are ordered \code{Y} values. Element \code{bivarSurf[1,1]} equals 1. Its row and column name is \code{'0'} (see the documentation for the return value \code{DabrowskaEst} in function \code{survDabrowska}).}
}
\value{
The following list of survival surfaces and their differentials is returned. \code{Sdxdy} is the marginal and joint probability mass functions in the same format as argument \code{bivarSurf}; \code{Sxy} is the joint survival probability; \code{SxMyM} is \code{Sxy} at point \code{(x-, y-)}, where \code{x-} is the left limit of \code{x}; \code{Sx} is the marginal survival probability function for variable X; \code{Sy} is the marginal survival probability function for variable Y; \code{Sdx} is the marginal probability mass function for variable X; \code{Sdy} is the marginal probability mass function for variable Y; \code{SxM} is the marginal survival probability function for X at point \code{x-}; \code{SyM} is the marginal survival probability function for Y at point \code{y-}; \code{SxM_y} is the joint survival probability function at point \code{(x-, y)}; \code{Sx_yM} is the joint survival probability function at point \code{(x, y-)}; \code{Sdx_y} is \code{SxM_y - Sxy}; \code{Sx_dy} is \code{Sx_yM - Sxy}; \code{Sdx_yM} is \code{SxMyM - Sx_yM}; \code{SxM_dy} is \code{SxMyM - SxM_y}.
}
\description{
The function computes marginal and joint probability mass functions from marginal and joint survival probabilities.
}
\details{
The function returns a list of survival surfaces and their differentials. Element \code{Sdxdy} of this list is the marginal and joint probability mass function in the same format as argument \code{bivarSurf}. The rest of the returned list elements are matrices in the same format as \code{bivarSurf} except that they do not contain marginal values and row/column names.
}
\examples{
X = c(0.5, 0.6, 0.8)
Y = c(0.44, 0.77, 0.99)
deltaX = c(1, 0, 1)
deltaY = c(1, 1, 1)

bivarSurf = survDabrowska(X, Y, deltaX, deltaY)$DabrowskaEst
bivarSurf

bivarPMF = survPMF(bivarSurf)$Sdxdy
bivarPMF

}
\author{
Svetlana K Eden, \email{svetlanaeden@gmail.com}
}
\keyword{PMF}
\keyword{bivariate}
\keyword{survival}
