% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{survival_to_cumulative_hazard}
\alias{survival_to_cumulative_hazard}
\title{Transform Survival to Cumulative Hazard}
\usage{
survival_to_cumulative_hazard(survival_functions, epsilon = 0)
}
\arguments{
\item{survival_functions}{matrix or vector, with each row representing a survival function}

\item{epsilon}{a positive numeric number to add, so that the logarithm can be taken}
}
\value{
A matrix or vector transformed to the form of a cumulative hazard function.
}
\description{
Helper function to transform between survival function and CHF
}
\examples{
library(survex)

vec <- c(1, 0.9, 0.8, 0.7, 0.6)
matr <- matrix(c(1, 0.9, 0.8, 1, 0.8, 0.6), ncol = 3)

survival_to_cumulative_hazard(vec)

survival_to_cumulative_hazard(matr)

}
