% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_model_diagnostics_survival.R
\name{plot.model_diagnostics_survival}
\alias{plot.model_diagnostics_survival}
\title{Plot Model Diagnostics for Survival Models}
\usage{
\method{plot}{model_diagnostics_survival}(
  x,
  ...,
  plot_type = "deviance",
  xvariable = "index",
  smooth = as.logical(xvariable != "index"),
  facet_ncol = NULL,
  title = "Model diagnostics",
  subtitle = "default",
  colors = NULL
)
}
\arguments{
\item{x}{an object of class \code{model_diagnostics_survival} to be plotted}

\item{...}{additional objects of class \code{model_diagnostics_survival} to be plotted together}

\item{plot_type}{character, either \code{"deviance"}, \code{"martingale"} or \code{"Cox-Snell"}. Selects the type of plot to be prepared. If \code{"deviance"} or \verb{"martingale} then deviance/martingale residuals are plotted against \code{xvariable}. If \code{"Cox-Snell"} then diagnostic plot of Cox-Snell residuals is prepared, which is CHF estimated based on Cox-Snell residuals against theoretical cumulative hazard trajectory of the Exp(1) -- diagonal line.}

\item{xvariable}{character, name of the variable to be plotted on x-axis (can be name of the variable to be drawn on the x-axis (can be any column from the \code{x$result}: explanatory variable, time, other residuals). By default \code{"index"} which gives the order of observations.}

\item{smooth}{logical, shall the smooth line be added. Only used when \code{plot_type = "deviance"} or \code{plot_type = "martingale"}.}

\item{facet_ncol}{number of columns for arranging subplots}

\item{title}{character, title of the plot}

\item{subtitle}{character, subtitle of the plot, \code{"default"} automatically generates "created for XXX, YYY models", where XXX and YYY are the explainer labels}

\item{colors}{character vector containing the colors to be used for plotting (containing either hex codes "#FF69B4", or names "blue").}
}
\value{
An object of the class \code{ggplot}.
}
\description{
This function plots objects of class \code{"model_diagnostics_survival"} created
using the \code{model_diagnostics()} function.
}
