% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coxtime.R
\name{coxtime}
\alias{coxtime}
\title{Cox-Time Survival Neural Network}
\usage{
coxtime(
  formula = NULL,
  data = NULL,
  reverse = FALSE,
  time_variable = "time",
  status_variable = "status",
  x = NULL,
  y = NULL,
  frac = 0,
  standardize_time = FALSE,
  log_duration = FALSE,
  with_mean = TRUE,
  with_std = TRUE,
  activation = "relu",
  num_nodes = c(32L, 32L),
  batch_norm = TRUE,
  dropout = NULL,
  device = NULL,
  shrink = 0,
  early_stopping = FALSE,
  best_weights = FALSE,
  min_delta = 0,
  patience = 10L,
  batch_size = 256L,
  epochs = 1L,
  verbose = FALSE,
  num_workers = 0L,
  shuffle = TRUE,
  ...
)
}
\arguments{
\item{formula}{\code{(formula(1))}\cr
Object specifying the model fit, left-hand-side of formula should describe a \code{\link[survival:Surv]{survival::Surv()}}
object.}

\item{data}{\code{(data.frame(1))}\cr
Training data of \code{data.frame} like object, internally is coerced with \code{\link[stats:model.matrix]{stats::model.matrix()}}.}

\item{reverse}{\code{(logical(1))}\cr
If \code{TRUE} fits estimator on censoring distribution, otherwise (default) survival distribution.}

\item{time_variable}{\code{(character(1))}\cr
Alternative method to call the function. Name of the 'time' variable, required if \code{formula}.
or \code{x} and \code{Y} not given.}

\item{status_variable}{\code{(character(1))}\cr
Alternative method to call the function. Name of the 'status' variable, required if \code{formula}
or \code{x} and \code{Y} not given.}

\item{x}{\code{(data.frame(1))}\cr
Alternative method to call the function. Required if \verb{formula, time_variable} and
\code{status_variable} not given. Data frame like object of features which is internally
coerced with \code{model.matrix}.}

\item{y}{\verb{([survival::Surv()])}\cr
Alternative method to call the function. Required if \verb{formula, time_variable} and
\code{status_variable} not given. Survival outcome of right-censored observations.}

\item{frac}{\code{(numeric(1))} \cr
Fraction of data to use for validation dataset, default is \code{0} and therefore no separate
validation dataset.}

\item{standardize_time}{\code{(logical(1))}\cr
If \code{TRUE}, the time outcome is standardized.}

\item{log_duration}{\code{(logical(1))}\cr
If \code{TRUE} and \code{standardize_time} is \code{TRUE} then time variable is log transformed.}

\item{with_mean}{\code{(logical(1))}\cr
If \code{TRUE} (default) and \code{standardize_time} is \code{TRUE} then time variable is centered.}

\item{with_std}{\code{(logical(1))}\cr
If \code{TRUE} (default) and \code{standardize_time} is \code{TRUE} then time variable is scaled to unit
variance.}

\item{activation}{\code{(character(1))} \cr
See \link{get_pycox_activation}.}

\item{num_nodes, batch_norm, dropout}{\code{(integer()/logical(1)/numeric(1))} \cr
See \link{build_pytorch_net}.}

\item{device}{\code{(integer(1)|character(1))}\cr
Passed to \code{pycox.models.Coxtime}, specifies device to compute models on.}

\item{shrink}{\code{(numeric(1))}\cr
Passed to \code{pycox.models.Coxtime}, shrinkage parameter for regularization.}

\item{early_stopping, best_weights, min_delta, patience}{\verb{(logical(1)/logical(1)/numeric(1)/integer(1)} \cr
See \link{get_pycox_callbacks}.}

\item{batch_size}{\code{(integer(1))}\cr
Passed to \code{pycox.models.Coxtime.fit}, elements in each batch.}

\item{epochs}{\code{(integer(1))}\cr
Passed to \code{pycox.models.Coxtime.fit}, number of epochs.}

\item{verbose}{\code{(logical(1))}\cr
Passed to \code{pycox.models.Coxtime.fit}, should information be displayed during
fitting.}

\item{num_workers}{\code{(integer(1))}\cr
Passed to \code{pycox.models.Coxtime.fit}, number of workers used in the
dataloader.}

\item{shuffle}{\code{(logical(1))}\cr
Passed to \code{pycox.models.Coxtime.fit}, should order of dataset be shuffled?}

\item{...}{\code{ANY} \cr
Passed to \link{get_pycox_optim}.}
}
\value{
An object inheriting from class \code{coxtime}.

An object of class \code{survivalmodel}.
}
\description{
Cox-Time fits a neural network based on the Cox PH with
time-varying effects.
}
\details{
Implemented from the \code{pycox} Python package via \CRANpkg{reticulate}.
Calls \code{pycox.models.Coxtime}.
}
\examples{
\donttest{
if (requireNamespaces("reticulate")) {
  # all defaults
  coxtime(data = simsurvdata(50))

  # common parameters
  coxtime(data = simsurvdata(50), frac = 0.3, activation = "relu",
    num_nodes = c(4L, 8L, 4L, 2L), dropout = 0.1, early_stopping = TRUE, epochs = 100L,
    batch_size = 32L)
}
}

}
\references{
Kvamme, H., Borgan, Ø., & Scheel, I. (2019).
Time-to-event prediction with neural networks and Cox regression.
Journal of Machine Learning Research, 20(129), 1–30.
}
