% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{clean_votes}
\alias{clean_votes}
\title{Cleans votes}
\usage{
clean_votes(df)
}
\arguments{
\item{df}{Data frame which must contain the \code{vote} data.}
}
\value{
Returns a tidy data frame
}
\description{
There are certain events in the game of survivor which mean someone may attend tribal council and
not get the change to vote for some reason or their vote is unique e.g. when rocks are drawn. You
may want to remove the votes that were not an actual vote for a person. \code{clean_votes} is a
convenience function to remove these records. Can be piped.
}
\examples{
library(dplyr)
vh <- vote_history \%>\%
filter(
  season == 40,
  episode == 10
) \%>\%
count(vote)
vh

vh \%>\%
clean_votes()
}
