% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{logLik.survstan}
\alias{logLik.survstan}
\title{Extract Log-Likelihood from a Fitted Model}
\usage{
\method{logLik}{survstan}(object, ...)
}
\arguments{
\item{object}{a fitted model of the class survstan}

\item{...}{further arguments passed to or from other methods.}
}
\value{
the log-likelihood value when a single model is passed to the function; otherwise, a data.frame with the log-likelihood values and the number of parameters is returned.
}
\description{
Extracts the log-likelihood function for a fitted parametric model.
}
\examples{
\donttest{
library(survstan)
fit1 <- aftreg(Surv(futime, fustat) ~ 1, data = ovarian, baseline = "weibull", init = 0)
fit2 <- aftreg(Surv(futime, fustat) ~ rx, data = ovarian, baseline = "weibull", init = 0)
fit3 <- aftreg(Surv(futime, fustat) ~ ecog.ps + rx, data = ovarian, baseline = "weibull", init = 0)
logLik(fit1, fit2, fit3)
}

}
