% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_nrisk_tbl.R
\name{get_nrisk_tbl}
\alias{get_nrisk_tbl}
\title{Returns a Number At Risk Table from a survfit Object}
\usage{
get_nrisk_tbl(sfit, timeby)
}
\arguments{
\item{sfit}{A survival::survfit object.}

\item{timeby}{The "step" in which to calculate the risk.}
}
\value{
A data.frame with the number of risks at each timeby step.
}
\description{
This function generates a number at risk table that typically seen in
publications.
}
\examples{
fit <- survival::survfit(survival::Surv(time,status) ~ rx, data = survival::colon)
get_nrisk_tbl(fit, timeby = 500)
}
\author{
Abhijit Dasgupta \url{https://gist.github.com/araastat/9927677}.
}

