% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/explain.R
\name{explain.default}
\alias{explain.default}
\alias{explain}
\title{Create Survival Model Explainer}
\usage{
explain.default(model, data = NULL, y, times = NULL,
  predict_function = yhat, link = I, label = tail(class(model), 1),
  ...)

explain(model, data = NULL, y, times = NULL, predict_function = yhat,
  link = I, label = tail(class(model), 1), ...)
}
\arguments{
\item{model}{object - a survival model to be explained}

\item{data}{data.frame, tibble or matrix - data that will be used by survival explainers. If not provided then will be extracted from the model}

\item{y}{object of class 'surv', contains event status and times}

\item{times}{optional argument, the vector of time points on which survival probability will be predicted}

\item{predict_function}{function that takes three arguments: model, new data, vector with times, and returns numeric vector or matrix with predictions. If not passed, function \code{\link[pec]{predictSurvProb}} is used.}

\item{link}{function - a transformation/link function that shall be applied to raw model predictions}

\item{label}{character - the name of the survival model. By default it's extracted from the 'class' attribute of the model.}

\item{...}{other parameters}
}
\value{
An object of the class 'surv_explainer'.

It's a list with following fields:

\itemize{
\item \code{model} the explained model
\item \code{data} the dataset
\item \code{y} event statuses and times
\item \code{times} time points on which survival probability is predicted
\item \code{predict_function} function that may be used for model predictions, shall return a single numerical value for each time.
\item \code{link} function - a transformation/link function that shall be applied to raw model predictions
\item \code{class} class/classes of a model
\item \code{label} label, by default it's the last value from the \code{class} vector, but may be set to any character.
}
}
\description{
Survival models may have very different structures.
This function creates a unified representation of a survival model, which can be further processed by various survival
explainers (see also \code{\link[DALEX]{explain}}).

Please NOTE, that the \code{model} is actually the only required argument.
But some survival explainers may require additional arguments.
}
\examples{
\donttest{
library(survxai)
library(rms)
library(randomForestSRC)
data(pbc, package = "randomForestSRC")
pbc <- pbc[complete.cases(pbc),]
predict_times <- function(model, data, times){
                  prob <- rms::survest(model, data, times = times)$surv
                  return(prob)
                  }
cph_model <- cph(Surv(days/365, status)~., data=pbc, surv=TRUE, x = TRUE, y=TRUE)
surve_cph <- explain(model = cph_model, data = pbc[,-c(1,2)], y = Surv(pbc$days/365, pbc$status),
             predict_function = predict_times)
}
}
