% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svSocket-package.R
\docType{package}
\name{svSocket-package}
\alias{svSocket}
\alias{svSocket-package}
\title{svSocket: 'SciViews' - Socket Server}
\description{
A socket server allows to connect clients to R.
}
\details{
The SciViews {svSocket} package provides a stateful, multi-client and
preemptive socket server. Socket transaction are operational even when R is
busy in its main event loop (calculation done at the prompt). This R socket
server uses the excellent asynchronous socket ports management by Tcl, and
thus, it needs a working version of Tcl/Tk (>= 8.4) and of the {tcltk} R
package.

A particular effort has been made to handle requests the same way as if they
where introduced at the command prompt, including presentation of the output.
However, the server sends results back to the client only at the end of the
computations. It means that any interaction during computation (for instance,
using \code{\link[=scan]{scan()}}, \code{\link[=browser]{browser()}}, or \code{par(ask = TRUE)} is not echoed in the client
on due time. If you parameterize the socket server to echo commands in the R
console, such interaction would be possible from there. Another option is to
run R in non-interactive mode.

Although initially designed to server GUI clients, the R socket server can
also be used to exchange data between separate R processes. The
\code{\link[=eval_socket_server]{eval_socket_server()}} function is particularly useful for this. Note,
however, that R objects are serialized into a text (i.e., using \code{\link[=dump]{dump()}})
format, currently. It means that the transfer of large object is not as
efficient as, say {Rserver} ({Rserver} exchanges R objects in binary format,
but {Rserver} is not stateful, clients do not share the same global workspace
and it does not allow concurrent use of the command prompt).

See \code{\link[=start_socket_server]{start_socket_server()}} and \code{\link[=process_socket_server]{process_socket_server()}} for further
implementation details.
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/SciViews/svSocket}
  \item \url{https://www.sciviews.org/svSocket/}
  \item Report bugs at \url{https://github.com/SciViews/svSocket/issues}
}

}
\author{
\strong{Maintainer}: Philippe Grosjean \email{phgrosjean@sciviews.org} (\href{https://orcid.org/0000-0002-2694-9471}{ORCID})

Other contributors:
\itemize{
  \item Matthew Dowle \email{mdowle@mdowle.plus.com} [contributor]
}

}
\keyword{internal}
