% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ld.dc.R
\name{id.dc}
\alias{id.dc}
\title{Independence-based identification of SVAR models based on distance covariances}
\usage{
id.dc(x, PIT = FALSE)
}
\arguments{
\item{x}{An object of class 'vars', 'vec2var', 'nlVar'. Estimated VAR object}

\item{PIT}{Logical. If PIT='TRUE', the distribution and density of the independent components are estimated using gaussian kernel density estimates}
}
\value{
A list of class "svars" with elements
\item{B}{Estimated structural impact matrix B, i.e. unique decomposition of the covariance matrix of reduced form errors}
\item{A_hat}{Estimated VAR parameter}
\item{method}{Method applied for identifaction}
\item{n}{Number of observations}
\item{type}{Type of the VAR model, e.g. 'const'}
}
\description{
Given an estimated VAR model, this function applies independence-based identification for the structural impact matrix B of the corresponding SVAR model
\deqn{y_t=c_t+A_1 y_{t-1}+...+A_p y_{t-p}+u_t  =c_t+A_1 y_{t-1}+...+A_p y_{t-p}+B \epsilon_t.}
Matrix B corresponds to the unique decomposition of the least squares covariance matrix \eqn{\Sigma_u=B B'} if the vector of structural shocks \eqn{\epsilon_t} contains at most one Gaussian shock (Comon, 1994).
A nonparametric dependence measure, the distance covariance (Szekely et al, 2007), determines least dependent structural shocks. The algorithm described in Matteson and Tsay (2013) is applied to calculate the matrix B.
}
\examples{

# data contains quarterly observations from 1965Q1 to 2008Q3
# x = output gap
# pi = inflation
# i = interest rates
set.seed(23211)
v1 <- vars::VAR(USA, lag.max = 10, ic = "AIC" )
x1 <- id.dc(v1)
summary(x1)

# switching columns according to sign pattern
x1$B <- x1$B[,c(3,2,1)]
x1$B[,3] <- x1$B[,3]*(-1)

# impulse response analysis
i1 <- imrf(x1, horizon = 30)
plot(i1, scales = 'free_y')


}
\references{
Matteson, D. S. & Tsay, R. S., 2013. Independent Component Analysis via Distance Covariance, pre-print\cr
     Szekely, G. J.; Rizzo, M. L. & Bakirov, N. K., 2007. Measuring and testing dependence by correlation of distances Ann. Statist., 35, 2769-2794\cr
     Comon, P., 1994. Independent component analysis, A new concept?, Signal Processing, 36, 287-314
}
\seealso{
For alternative identification approaches see \code{\link{id.cvm}}, \code{\link{id.cv}} or \code{\link{id.ngml}}
}
