% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SVG.R
\name{svglite}
\alias{svglite}
\title{An SVG Graphics Driver}
\usage{
svglite(file = "Rplots.svg", width = 10, height = 8, bg = "white",
  pointsize = 12, standalone = TRUE)
}
\arguments{
\item{file}{The file where output will appear.}

\item{height, width}{Height and width in inches.}

\item{bg}{Default background color for the plot (defaults to "white").}

\item{pointsize}{Default point size.}

\item{standalone}{Produce a standalone svg file? If \code{FALSE}, omits
xml header and default namespace.}
}
\description{
This function produces graphics compliant to the current w3 svg XML standard.
The driver output is currently NOT specifying a DOCTYPE DTD.
}
\examples{
# Save to file
svglite("Rplots.svg")
plot(1:11, (-5:5)^2, type = 'b', main = "Simple Example")
dev.off()

}
\author{
This driver was written by T Jake Luciani
  \email{jakeluciani@yahoo.com} 2012: updated by Matthieu Decorde
  \email{matthieu.decorde@ens-lyon.fr}
}
\references{
\emph{W3C Scalable Vector Graphics (SVG)}:
  \url{http://www.w3.org/Graphics/SVG/Overview.htm8}
}
\seealso{
\code{\link{pictex}}, \code{\link{postscript}}, \code{\link{Devices}}
}
\keyword{device}

