% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svinecop.R
\name{svinecop}
\alias{svinecop}
\title{Stationary vine copula models}
\usage{
svinecop(
  data,
  p,
  var_types = rep("c", NCOL(data)),
  family_set = "all",
  cs_structure = NA,
  out_vertices = NA,
  in_vertices = NA,
  type = "S",
  par_method = "mle",
  nonpar_method = "constant",
  mult = 1,
  selcrit = "aic",
  weights = numeric(),
  psi0 = 0.9,
  presel = TRUE,
  trunc_lvl = Inf,
  tree_crit = "tau",
  threshold = 0,
  keep_data = FALSE,
  show_trace = FALSE,
  cores = 1
)
}
\arguments{
\item{data}{a matrix or data.frame (copula data should have approximately
uniform margins).}

\item{p}{the Markov order.}

\item{var_types}{variable types; discrete variables not (yet) allowed.}

\item{family_set}{a character vector of families; see \code{\link[rvinecopulib:bicop]{rvinecopulib::bicop()}}
for additional options.}

\item{cs_structure}{the cross-sectional vine structure (see
\code{\link[rvinecopulib:rvine_structure]{rvinecopulib::rvine_structure()}}; \code{cs_structure = NA} performs automatic
structure selection.}

\item{out_vertices}{the out-vertex; if \code{NA}, the out-vertex is selected
automatically if no structure is provided, and is equivalent to 1 if a
structure is provided.}

\item{in_vertices}{the in-vertex; if \code{NA}, the in-vertex is selected
automatically if no structure is provided, and is equivalent to 1 if a
structure is provided.}

\item{type}{type of stationary vine; \code{"S"} (default) for general S-vines,
\code{"D"} for Smith's long D-vine, \code{"M"} for Beare and Seo's M-vine.}

\item{par_method}{the estimation method for parametric models, either \code{"mle"}
for sequential maximum likelihood, \code{"itau"} for inversion of Kendall's tau
(only available for one-parameter families and \code{"t"}.}

\item{nonpar_method}{the estimation method for nonparametric models, either
\code{"constant"} for the standard transformation estimator, or
\code{"linear"}/\code{"quadratic"} for the local-likelihood approximations of order
one/two.}

\item{mult}{multiplier for the smoothing parameters of nonparametric
families. Values larger than 1 make the estimate more smooth, values less
than 1 less smooth.}

\item{selcrit}{criterion for family selection, either \code{"loglik"}, \code{"aic"},
\code{"bic"}, \code{"mbic"}. For \code{vinecop()} there is the additional option
\code{"mbicv"}.}

\item{weights}{optional vector of weights for each observation.}

\item{psi0}{prior probability of a non-independence copula (only used for
\code{selcrit = "mbic"} and \code{selcrit = "mbicv"}).}

\item{presel}{whether the family set should be thinned out according to
symmetry characteristics of the data.}

\item{trunc_lvl}{currently unsupported.}

\item{tree_crit}{the criterion for tree selection, one of \code{"tau"}, \code{"rho"},
\code{"hoeffd"}, or \code{"mcor"} for Kendall's \eqn{\tau}, Spearman's \eqn{\rho},
Hoeffding's \eqn{D}, and maximum correlation, respectively.}

\item{threshold}{for thresholded vine copulas; \code{NA} indicates that the
threshold should be selected automatically by \code{\link[rvinecopulib:mBICV]{rvinecopulib::mBICV()}}.}

\item{keep_data}{whether the data should be stored (necessary for using
\code{\link[=fitted]{fitted()}}).}

\item{show_trace}{logical; whether a trace of the fitting progress should be
printed.}

\item{cores}{number of cores to use; if more than 1, estimation of pair
copulas within a tree is done in parallel.}
}
\value{
Returns the fitted model as an object with classes
\code{svinecop} and \code{svinecop_dist}. Also inherits from \code{vinecop}, \code{vinecop_dist}
such that many functions from \code{rvinecopulib} can be called.
}
\description{
Automated fitting or creation of custom S-vine copula models
}
\examples{
# load data set
data(returns)  

# convert to pseudo observations with empirical cdf for marginal distributions
u <- pseudo_obs(returns[1:100, 1:3]) 

# fit parametric S-vine copula model with Markov order 1
fit <- svinecop(u, p = 1, family_set = "parametric")
fit 
summary(fit)
plot(fit)
contour(fit)
logLik(fit)

pairs(svinecop_sim(500, rep = 1, fit))
}
