\name{svyPVprob}
\alias{svyPVprob}

\title{
Proportion estimation
}
\description{
This function was created to estimate the proportions of weighted observations within each group.
}
\usage{
svyPVprob(by, svydat, pvs = NULL, colN=FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{by}{
A formula statement is expected which splits the data into several subsets.
}
  \item{svydat}{
A survey design (\code{svydesign} as well as \code{svrepdesign}) which was generated by the \code{survey} package.
}
  \item{pvs}{
Either a character vector which contains variablenames (these variables must exist within the survey) or a vector of length 1 which contains NULL. If plausible values (or any other variablenames) are provided by the argument \code{pvs} the weighted ratio of group members is computed after listwise deletion of those who contain any NA.

}

  \item{colN}{
If TRUE the colnames will equal the grouping variable names from the by statement. If FALSE, which is the default, the names will be Group1 up to Group k.}

}

\value{
The function returns a data.frame with the following columns
\item{Group1..k}{The first k columns show the different levels of the k subsetting groups.}
\item{Number.of.cases}{Shows the unweighted number of cases (NA's excluded) within each group.}
\item{Sum.of.weights}{Shows the sum of weights (NA's excluded) within each group.}
\item{Proportion}{Shows the (weighted) estimated proportion of persons within the categories.}
\item{Proportion.SE}{Shows the Standard Errors of the proportion estimate.}
}

\references{
Lumley, T. (2010). \emph{Complex Surveys}. Hoboken, NJ: Wiley.

Saerndal, C.-E. & Swensson, B. & Wretman, J. (1992). \emph{Model Assisted Survey Sampling}. New York: Springer.

Chaudhuri, A. & Stenger, H. (2005). \emph{Survey Sampling. Theory and Methods}. Boka Raton, FL: Chapman & Hall/CRC.
}

\author{
Manuel Reif
}


\seealso{
\code{\link{svyPVprob}}
}

\examples{

data(svy_example1)

erg_p <- svyPVprob(by = ~ sex, svydat=svy.exrep, pvs=c("plaus1","plaus2","plaus3"))

erg_p

}

\keyword{proportion}

