% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velocities.R
\name{add_set_vels}
\alias{add_set_vels}
\title{Add Velocity Timeseries}
\usage{
add_set_vels(
  data,
  geo = FALSE,
  verbose = FALSE,
  parallelize = FALSE,
  independent_call = TRUE
)
}
\arguments{
\item{data}{A dataframe with the time series of individuals' positions.
Columns must include: \code{t}, \code{id}, \code{x}, \code{y}.}

\item{geo}{Logical, whether positions are geographic coordinates, default = TRUE.}

\item{verbose}{Logical, whether to post updates on progress, default = FALSE.}

\item{parallelize}{Logical, whether to run the function in parallel, default = FALSE.}

\item{independent_call}{Logical, whether the function is called by itself or
as part of the package pipeline (through \code{\link{add_velocities}}). The default is
set to TRUE, reflecting the direct call of the function by the user.}
}
\value{
The input dataframe with a new speed and heading (rotational, in rads) columns.
}
\description{
This function calculates the headings and speeds of individuals based on
two location points and the time taken to travel between those points.
}
\examples{

data <- data.frame(
x = rnorm(25, sd = 3),
y = rnorm(25, sd = 3),
t = as.POSIXct(1:25, origin = Sys.time()),
id = rep(1, 25)
)

data <- add_set_vels(data, geo = FALSE)

}
\seealso{
\code{\link{add_velocities}}
}
\author{
Marina Papadopoulou \email{m.papadopoulou.rug@gmail.com}
}
