% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/swaRm_bearing_angle.R
\name{nnba}
\alias{nnba}
\title{Bearing Angle to Nearest Neighbor}
\usage{
nnba(x, y, hs, geo = FALSE)
}
\arguments{
\item{x}{A vector of x (or longitude) coordinates.}

\item{y}{A vector of y (or latitude) coordinates.}

\item{hs}{A vector of headings (angle in rads).}

\item{geo}{A logical value indicating whether the locations are defined by
geographic coordinates (pairs of longitude/latitude values). Default: FALSE.}
}
\value{
A vector of the same length as x and y representing the distance to
 the nearest neighboring object for each object.
}
\description{
Given the locations and headings of different objects,
 this function determines the angle between the heading of each object
 and the position to the nearest neighboring object.
}
\examples{
x <- rnorm(25)
y <- rnorm(25, sd = 3)
hs <- rnorm(25, sd = 1)
nnba(x, y, hs)

}
\seealso{
\code{\link{pdist}}
}
\author{
Simon Garnier, \email{garnier@njit.edu},
 Marina Papadopoulou, \email{m.papadopoulou.rug@gmail.com}
}
