\name{scbGetData}
\alias{scbGetData}
\title{Get data from a bottom node in SCB API}
\usage{
  scbGetData(url, dims, clean = FALSE)
}
\arguments{
  \item{url}{URL to get data from (it is usually sufficient
  to submit the base URL, supplied via the baseURL()
  function, and the name of the variable).}

  \item{dims}{A list of dimensional parameters to filter
  data by. Note that values \emph{must} be submitted for
  all dimensions of the data. If you don't want to filter
  data, submit an asterisk in quotation marks ("*") instead
  of values for that dimension.}

  \item{clean}{Clean and melt the data to R format.}
}
\description{
  This function fetches actual data (i.e. values) from the
  SCB web API.
}
\details{
  There are five documented filter types in the SCB API
  documentation; "Item", "All", "Top", "Agg" and "Vs". This
  function currently only supports the "Item" and "All"
  modes. To use "Item" selection, simply submit a value or
  vector of values with each dimensional parameter. To use
  "All" selection, submit a wildcard asterisk ("*") instead
  of a value. For detailed examples see the installed
  example files in the \code{examples} folder of
  \code{path.package("sweSCB")} (these are also viewable on
  the project's GitHub page).
}
\examples{
## CONTINUED FROM EXAMPLES IN scbGetMetadata()
# Get metadata for a variable
url <- paste(c(baseURL(),"AM","AM0102","AM0102A","KLStabell14LpMan"), collapse="/")
metadata <- scbGetMetadata(url)

# Get dimensions (names of dimensions are printed in the terminal)
dims <- scbGetDims(metadata)

# Get data
test <- scbGetData(metadata$URL, dims=list(
   Myndighet = "C02",
   Kon = "*",
   Heltiddeltid = "*",
   ContentsCode = "*",
   Tid = "*"
))

# Examine data
View(test)
}
\seealso{
  \code{\link{scbGetMetadata}}, \code{\link{scbGetDims}},
  \code{\link{scbGetLevels}}
}

