% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airdas_segdata.R
\name{airdas_segdata}
\alias{airdas_segdata}
\alias{airdas_segdata.data.frame}
\alias{airdas_segdata.airdas_df}
\title{Summarize AirDAS data for a continuous effort section}
\usage{
airdas_segdata(x, ...)

\method{airdas_segdata}{data.frame}(x, ...)

\method{airdas_segdata}{airdas_df}(
  x,
  conditions,
  segdata.method = c("avg", "maxdist"),
  seg.lengths,
  section.id,
  ...
)
}
\arguments{
\item{x}{\code{airdas_df} object, 
or a data frame that can be coerced to a \code{airdas_df} object.
Must contain a single continuous effort section of AirDAS data; 
see the Details section below}

\item{...}{ignored}

\item{conditions}{see \code{\link{airdas_effort}}, or
see Details section for more information}

\item{segdata.method}{character; either \code{"avg"} or \code{"maxdist"}.
\code{"avg"} means the condition values will be
calculated as a weighted average by distance, while
\code{"maxdist"} means the condition values will be those recorded
for the longest distance during that segment}

\item{seg.lengths}{numeric; length of the modeling segments 
into which \code{x} will be chopped}

\item{section.id}{numeric; the ID of \code{x} (the current continuous effort section)}
}
\value{
Data frame with the segdata information described above
  and in \code{\link{airdas_effort}}
}
\description{
Summarize AirDAS effort data by effort segment, while averaging conditions
}
\details{
This function was designed to be called by one of the airdas_chop_ functions, 
  e.g. \code{\link{airdas_chop_equallength}}, and thus 
  users should avoid calling it themselves.
  It loops through the events in \code{x}, calculating and storing relevant
  information for each modeling segment as it goes. 
  Because \code{x} is a continuous effort section, it must begin with 
  a "T" or "R" event and end with the corresponding "E" or "O" event.

  For each segment, this function reports the 
  segment ID, transect code, the start/end/midpoints (lat/lon), segment length, 
  year, month, day, time, observers, 
  and average conditions (which are specified by \code{conditions}).
  The segment ID is designated as \code{section.id} _ index of the modeling segment.
  Thus, if \code{section.id} is \code{1}, then the segment ID for 
  the second segment from \code{x} is \code{"1_2"}.
  
  When \code{segdata.method} is \code{"avg"}, the condition values are
  calculated as a weighted average by distance.
  The reported value for logical columns (e.g. Haze) is the percentage
  (in decimals) of the segment in which that condition was \code{TRUE}.
  For character columns, the reported value for each segment is
  the unique value(s) present in the segment, with \code{NA}s omitted,
  pasted together via \code{paste(..., collapse = "; ")}.
  When \code{segdata.method} is \code{"maxdist"}, the reported values
  are, for each condition, the value recorded for the longest distance
  during that segment (with \code{NA}s omitted).

  Transect code, file name, and vent code that started the continuous effort section 
  are also included in the segdata output.
  These values (excluding \code{NA}s) must be consistent across the
  entire effort section, and thus across all segments in \code{x};
  a warning is printed if there are any inconsistencies.
  
  \code{\link[swfscMisc]{bearing}} and \code{\link[swfscMisc]{destination}}
  are used to calculate the segment start, mid, and end points,
  with \code{method = "vincenty"}.
}
\keyword{internal}
