% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/das_comments.R
\name{das_comments}
\alias{das_comments}
\alias{das_comments.data.frame}
\alias{das_comments.das_df}
\alias{das_comments.das_dfr}
\title{Extract comments from DAS data}
\usage{
das_comments(x)

\method{das_comments}{data.frame}(x)

\method{das_comments}{das_df}(x)

\method{das_comments}{das_dfr}(x)
}
\arguments{
\item{x}{an object of class \code{das_dfr} or \code{das_df},
or a data frame that can be coerced to a \code{das_dfr} object}
}
\value{
\code{x}, filtered for C events and with the added column
  comment_str containing the concatenated comment strings
}
\description{
Extract comments from DAS data
}
\details{
This function recreates the comment strings by
  pasting the Data# columns back together for the C events (comments).
  See the examples section for how to search for comments with certain phrases
}
\examples{
y <- system.file("das_sample.das", package = "swfscDAS")
y.proc <- das_process(y)

das_comments(y.proc)

# Extract all comments containing "record" - could also use stringr pacakge
y.comm <- das_comments(y.proc)
y.comm[grepl("record", y.comm$comment_str, ignore.case = TRUE), ]

# Join comments with processed data
dplyr::left_join(y.proc, y.comm[, c("file_das", "line_num", "comment_str")],
                 by = c("file_das", "line_num"))

}
