% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample.map.R
\name{sample.map}
\alias{sample.map}
\title{Plot Samples on World Map}
\usage{
sample.map(lat, lon, lat.range = NULL, lon.range = NULL, main = NULL,
  pch = 19, pt.cex = 1, col = "black", bg = col, n = 5, lon.n = n,
  lat.n = n)
}
\arguments{
\item{lon, lat}{vectors giving the longitude and latitude of points to plot.}

\item{lon.range, lat.range}{vectors giving the minimum and maximum longitude 
and latitude of the map. If the first value in \code{lon.range} is greater 
than the second value, then a Pacific-centric map (\code{\link[mapdata]{world2Hires}}) 
is used and continents will not be filled in.}

\item{main}{main title for the plot.}

\item{pch}{point symbol to use.}

\item{pt.cex}{point size to use.}

\item{col}{point color.}

\item{bg}{background color of point.}

\item{n, lon.n, lat.n}{the number of tick marks desired. Can be specified 
separately for longitude (\code{lon.n}) or latitude (\code{lat.n}). 
See \code{\link{pretty}} for more details.}
}
\value{
original \code{\link{par}} settings for \code{mar} and \code{oma}.
}
\description{
Plot a set of samples on a world map.
}
\examples{

# Some random points around San Diego, CA
lat <- runif(30, 32.5, 33.3)
lon <- runif(30, -118.3, -117.5)
lat.range <- c(32.4, 33.6)
lon.range <- c(-118.6, -117)
sample.map(lat, lon, lat.range, lon.range)

# Some random points in the Pacific
lat <- runif(30, 20, 50)
lon <- c(runif(15, 150, 180), runif(15, -180, -120))
lat.range <- c(10, 75)
lon.range <- c(110, -110)
sample.map(lat, lon, lat.range, lon.range)

}
\author{
Eric Archer \email{eric.archer@noaa.gov}
}
\seealso{
\code{\link{lat.lon.axes}}
}

