% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_data.R
\name{get_data}
\alias{get_data}
\title{Retrieve data from WebServices}
\usage{
get_data(
  table,
  package_size = 1000,
  stop = T,
  attempts = 10,
  wtf = 1,
  silent = F,
  ...
)
}
\arguments{
\item{table}{name of the table to download. For an overview of available tables use \code{\link{get_tables}()}.}

\item{package_size}{number of rows to download at once (maximum = 1000). If a query exceeds \code{package_size},
it is internally split into multiple subqueries of size \code{package_size}.}

\item{stop}{if \code{TRUE}, the query process is interrupted if the query is invalid. It also indicates whether
a non-existent table or variable was used in the query. If \code{FALSE}, nothing is returned.}

\item{attempts}{maximum number of repetitions of a single subquery if it was not successful.}

\item{wtf}{factor for extending the waiting time after unsuccessful queries. If \code{wtf = 1}, the waiting
time corresponds to the number of unsuccessful attempts in seconds. For \code{attemps = 10} and
\code{wtf = 1}, a query is repeated for a maximum of 45 seconds. The waiting time increases proportionally
with \code{wtf}.}

\item{silent}{if \code{TRUE}, no progress bar and messages are displayed.}

\item{...}{optional filter arguments with values. Since all entries are available in several languages, it is
recommended to filter the calls by language., e.g. \code{get_data(table = "Person", Language = "DE")}.
For a table-specific preview use \code{\link{get_glimpse}()} or \code{\link{get_variables}()}. The following
things are to consider:
\itemize{
\item numbers for identification numbers, for example, must be entered as numeric vectors: e.g.
\code{get_data(table = "Voting", PersonNumber = c(21, 4167), Language = "DE")}.
\item dates must be entered as character vectors in yyyy-mm-dd format. \code{>} and \code{<} can be
used to query periods: e.g. \code{get_data(table = "Bill", SubmissionDate = c(">2018-12-31", "<2019-02-01"),
 Language = "DE")}.
\item the '~' can be used as substring search for character variables: e.g. \code{get_data(table = "Bill",
Title = "~CO2", Language = "DE")}.
}}
}
\value{
A tibble of different length and variable composition.
}
\description{
\code{get_data} retrieves data from the WebServices of the Swiss Parliament.
}
\examples{
\donttest{
# Retrieve data on the members of the Swiss Parliament
get_data(table = "Person", Language = "DE")

# Retrieve voting behavior of selected councillors
get_data(
   table = "Voting",
   PersonNumber = c(21, 4167),
   Language = "DE"
   )

# Retrieve businesses submitted during a specified period
get_data(
    table = "Business",
    SubmissionDate = c(">2018-12-31", "<2019-02-01"),
    Language = "DE"
    )

# Retrieve businesses on the subject of CO2
get_data(
    table = "Business",
    Title = "~CO2",
    Language = "DE"
    )
}
}
