% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readability_word_stats_by.R
\name{readability_word_stats_by}
\alias{readability_word_stats_by}
\title{Readability Word Statistics By Grouping Variable(s)}
\usage{
readability_word_stats_by(x, group, group.names, as.tibble = tibble_output(),
  ...)
}
\arguments{
\item{x}{A character vector.}

\item{group}{The grouping variable(s).  Takes a single grouping variable or a
list of 1 or more grouping variables.}

\item{group.names}{A vector of names that corresponds to group.  Generally
for internal use.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{ignored.}
}
\value{
Returns a \code{\link[base]{data.frame}}
(\code{\link[data.table]{data.table}}) readability word statistics.
}
\description{
Word statistics commonly used to calculate readability sores by grouping variable(s).
}
\examples{
dat <- data.frame(
   text = c("I like excellent chicken.", "I want eggs Benedict now.", "Really?"),
   group = c("A", "B", "A")
)
readability_word_stats_by(dat$text, dat$group)

with(presidential_debates_2012, readability_word_stats_by(dialogue, person))
with(presidential_debates_2012, readability_word_stats_by(dialogue, list(role, time)))
with(presidential_debates_2012, readability_word_stats_by(dialogue, list(person, time)))
}

