% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.sylly.env.R
\name{get.sylly.env}
\alias{get.sylly.env}
\title{Get sylly session environment}
\usage{
get.sylly.env(..., errorIfUnset = TRUE)
}
\arguments{
\item{...}{Named parameters to get from the sylly environment. Valid arguments are:
\describe{
  \item{lang}{ Logical, whether the set language should be returned.}
  \item{hyph.cache.file}{ Logical,
      whether the set hyphenation cache file for \code{hyphen} should be returned.}
  \item{hyph.max.token.length}{ Logical,
      whether the set maximum token length should be returned.}
}}

\item{errorIfUnset}{Logical, if \code{TRUE} and the desired property is not set at all,
      the function will fail with an error message.}
}
\value{
A character string or list, possibly including:
 \item{lang}{The specified language}
 \item{hyph.cache.file}{The specified hyphenation cache file for \code{hyphen}}
}
\description{
The function \code{get.sylly.env} returns information on your session environment regarding the sylly package,
      e.g.
whether a cache file should be used,
      if it was set before using \code{\link[sylly:set.sylly.env]{set.sylly.env}}.
}
\examples{
set.sylly.env(hyph.cache.file=file.path(tempdir(), "cache_file.RData"))
get.sylly.env(hyph.cache.file=TRUE)
}
\seealso{
\code{\link[sylly:set.sylly.env]{set.sylly.env}}
}
\keyword{misc}
