/*
 * Decompiled with CFR 0.152.
 */
package blbutil;

import blbutil.Utilities;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.zip.GZIPOutputStream;
import net.sf.samtools.util.BlockCompressedOutputStream;

public class FileUtil {
    public static final int DEFAULT_BUFFER_SIZE = 0xA00000;

    private FileUtil() {
    }

    public static PrintWriter bgzipPrintWriter(File file, int n) {
        PrintWriter printWriter = null;
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            printWriter = new PrintWriter(new BlockCompressedOutputStream(new BufferedOutputStream(fileOutputStream, n), file));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error opening " + file, fileNotFoundException);
        }
        return printWriter;
    }

    public static PrintWriter bgzipPrintWriter(File file) {
        return FileUtil.bgzipPrintWriter(file, 0xA00000);
    }

    public static DataInputStream dataInputStream(File file) {
        DataInputStream dataInputStream = null;
        try {
            dataInputStream = new DataInputStream(new BufferedInputStream(new FileInputStream(file), 0xA00000));
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error opening " + file, fileNotFoundException);
        }
        return dataInputStream;
    }

    public static DataOutputStream dataOutputStream(File file, int n) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            Utilities.exit("Error opening " + file, fileNotFoundException);
        }
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(fileOutputStream, n));
        return dataOutputStream;
    }

    public static DataOutputStream dataOutputStream(File file) {
        return FileUtil.dataOutputStream(file, 0xA00000);
    }

    public static PrintWriter gzipPrintWriter(File file) {
        return FileUtil.gzipPrintWriter(file, 0xA00000);
    }

    public static PrintWriter gzipPrintWriter(File file, int n) {
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new GZIPOutputStream((OutputStream)new FileOutputStream(file), n));
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening " + file, iOException);
        }
        return printWriter;
    }

    public static PrintWriter printWriter(File file) {
        return FileUtil.printWriter(file, false);
    }

    public static PrintWriter stdOutPrintWriter() {
        return new PrintWriter(new BufferedOutputStream(System.out, 0xA00000));
    }

    public static PrintWriter printWriter(File file, boolean bl) {
        return FileUtil.printWriter(file, bl, 0xA00000);
    }

    public static PrintWriter printWriter(File file, boolean bl, int n) {
        if (n == 0) {
            return FileUtil.nonBufferedFileWriter(file, bl);
        }
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter(new BufferedWriter(new FileWriter(file, bl), n));
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening " + file, iOException);
        }
        return printWriter;
    }

    private static PrintWriter nonBufferedFileWriter(File file, boolean bl) {
        boolean bl2 = true;
        PrintWriter printWriter = null;
        try {
            printWriter = new PrintWriter((Writer)new FileWriter(file, bl), bl2);
        }
        catch (IOException iOException) {
            Utilities.exit("Error opening " + file, iOException);
        }
        return printWriter;
    }

    public static File tempFile(String string) {
        File file = null;
        try {
            file = File.createTempFile(string, null);
            file.deleteOnExit();
        }
        catch (IOException iOException) {
            Utilities.exit("Exception thrown by createTempFile: ", iOException);
        }
        return file;
    }
}

