/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.ChromInterval;
import beagleutil.Samples;
import blbutil.Filter;
import blbutil.FilterUtils;
import blbutil.SampleFileIterator;
import haplotype.HapPair;
import haplotype.RefHapPairs;
import haplotype.WrappedHapPair;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import vcf.BasicGL;
import vcf.Data;
import vcf.FilteredVcfIterator;
import vcf.GL;
import vcf.IntervalVcfIterator;
import vcf.Marker;
import vcf.Markers;
import vcf.RefGL;
import vcf.VcfEmission;
import vcf.VcfEmissionIterator;
import vcf.VcfIterator;
import vcf.VcfRecord;
import vcf.VcfRefIterator;
import vcf.VcfWindow;

public class AllData
implements Data {
    private int window = 0;
    private VcfEmission[] refData;
    private GL refEmissions;
    private VcfEmission[] targetData;
    private int[] refIndices;
    private int[] targetIndices;
    private GL targetEmissions;
    private final List<HapPair> refHaps;
    private final List<HapPair> targetRefHaps;
    private final VcfWindow refWindow;
    private final VcfWindow targetWindow;

    private AllData(VcfWindow vcfWindow, VcfWindow vcfWindow2) {
        AllData.checkSampleOverlap(vcfWindow.samples(), vcfWindow2.samples());
        this.refWindow = vcfWindow;
        this.targetWindow = vcfWindow2;
        this.refData = new VcfEmission[0];
        this.refEmissions = new RefGL(vcfWindow.samples(), this.refData);
        this.targetData = new VcfEmission[0];
        this.refIndices = new int[0];
        this.targetIndices = new int[0];
        this.targetEmissions = new BasicGL(vcfWindow2.samples(), this.targetData);
        this.refHaps = new ArrayList<HapPair>(0);
        this.targetRefHaps = new ArrayList<HapPair>(0);
    }

    private static Filter<Marker> restrictToVcfMarkers(File file, Filter<Marker> filter, ChromInterval chromInterval) {
        HashSet<Marker> hashSet = new HashSet<Marker>(50000);
        SampleFileIterator<VcfRecord> sampleFileIterator = new VcfIterator(file);
        if (chromInterval != null) {
            sampleFileIterator = new IntervalVcfIterator(sampleFileIterator, chromInterval);
        }
        if (filter != null) {
            sampleFileIterator = new FilteredVcfIterator(sampleFileIterator, filter);
        }
        while (sampleFileIterator.hasNext()) {
            hashSet.add(((VcfRecord)sampleFileIterator.next()).marker());
        }
        return FilterUtils.includeFilter(hashSet);
    }

    private static void checkSampleOverlap(Samples samples, Samples samples2) {
        int n;
        int n2 = samples.nSamples();
        int n3 = samples2.nSamples();
        int n4 = n2 + n3;
        int[] nArray = new int[n4];
        for (n = 0; n < n2; ++n) {
            nArray[n] = samples.idIndex(n);
        }
        for (n = 0; n < n3; ++n) {
            nArray[n2 + n] = samples2.idIndex(n);
        }
        Arrays.sort(nArray);
        for (n = 1; n < nArray.length; ++n) {
            if (nArray[n - 1] != nArray[n]) continue;
            String string = "Overlap between reference and non-reference samples: " + samples.id(nArray[n - 1]);
            throw new IllegalArgumentException(string);
        }
    }

    public static Data gt(File file, File file2, Filter<String> filter, Filter<Marker> filter2, ChromInterval chromInterval, File file3, boolean bl, boolean bl2) {
        if (!bl2) {
            filter2 = AllData.restrictToVcfMarkers(file2, filter2, chromInterval);
        }
        SampleFileIterator<VcfRecord> sampleFileIterator = VcfIterator.filteredIterator(file, filter, filter2, chromInterval);
        VcfRefIterator vcfRefIterator = new VcfRefIterator(sampleFileIterator);
        VcfWindow vcfWindow = new VcfWindow(vcfRefIterator);
        SampleFileIterator<VcfRecord> sampleFileIterator2 = VcfIterator.filteredIterator(file2, filter, filter2, chromInterval);
        SampleFileIterator<VcfEmission> sampleFileIterator3 = VcfEmissionIterator.gt(sampleFileIterator2, file3, bl);
        VcfWindow vcfWindow2 = new VcfWindow(sampleFileIterator3);
        return new AllData(vcfWindow, vcfWindow2);
    }

    public static Data gl(File file, File file2, Filter<String> filter, Filter<Marker> filter2, ChromInterval chromInterval, File file3, float f, boolean bl) {
        if (!bl) {
            filter2 = AllData.restrictToVcfMarkers(file2, filter2, chromInterval);
        }
        SampleFileIterator<VcfRecord> sampleFileIterator = VcfIterator.filteredIterator(file, filter, filter2, chromInterval);
        VcfRefIterator vcfRefIterator = new VcfRefIterator(sampleFileIterator);
        VcfWindow vcfWindow = new VcfWindow(vcfRefIterator);
        SampleFileIterator<VcfRecord> sampleFileIterator2 = VcfIterator.filteredIterator(file2, filter, filter2, chromInterval);
        SampleFileIterator<VcfEmission> sampleFileIterator3 = VcfEmissionIterator.gl(sampleFileIterator2, file3, f);
        VcfWindow vcfWindow2 = new VcfWindow(sampleFileIterator3);
        return new AllData(vcfWindow, vcfWindow2);
    }

    public static Data gtgl(File file, File file2, Filter<String> filter, Filter<Marker> filter2, ChromInterval chromInterval, File file3, boolean bl, float f, boolean bl2) {
        if (!bl2) {
            filter2 = AllData.restrictToVcfMarkers(file2, filter2, chromInterval);
        }
        boolean bl3 = false;
        SampleFileIterator<VcfRecord> sampleFileIterator = VcfIterator.filteredIterator(file, filter, filter2, chromInterval);
        VcfRefIterator vcfRefIterator = new VcfRefIterator(sampleFileIterator);
        VcfWindow vcfWindow = new VcfWindow(vcfRefIterator);
        SampleFileIterator<VcfRecord> sampleFileIterator2 = VcfIterator.filteredIterator(file2, filter, filter2, chromInterval);
        SampleFileIterator<VcfEmission> sampleFileIterator3 = VcfEmissionIterator.gtgl(sampleFileIterator2, file3, bl, f, bl3);
        VcfWindow vcfWindow2 = new VcfWindow(sampleFileIterator3);
        return new AllData(vcfWindow, vcfWindow2);
    }

    @Override
    public boolean lastWindowOnChrom() {
        return this.refWindow.lastWindowOnChrom();
    }

    @Override
    public boolean canAdvanceWindow() {
        return this.refWindow.canAdvanceWindow();
    }

    @Override
    public void advanceWindow(int n, int n2) {
        this.refData = this.refWindow.advanceWindow(n, n2);
        this.refEmissions = new RefGL(this.refWindow.samples(), this.refData);
        this.targetData = this.targetWindow.advanceWindow(this.refEmissions.markers());
        this.refIndices = AllData.refIndices(this.targetData);
        this.targetIndices = AllData.targetIndices(this.targetData);
        this.targetEmissions = AllData.targetEmissions(this.targetWindow.samples(), this.targetData, this.refIndices);
        ++this.window;
        this.setRefHaplotypes(this.refEmissions.markers(), this.refData);
        this.setTargetRefHaplotypes(this.targetEmissions.markers(), this.refData, this.refIndices);
    }

    @Override
    public int window() {
        return this.window;
    }

    private static int[] refIndices(VcfEmission[] vcfEmissionArray) {
        int n = 0;
        for (VcfEmission vcfEmission : vcfEmissionArray) {
            if (vcfEmission == null) continue;
            ++n;
        }
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < vcfEmissionArray.length; ++i) {
            if (vcfEmissionArray[i] == null) continue;
            nArray[n2++] = i;
        }
        if (n2 != nArray.length) {
            throw new IllegalStateException("vma modification detected");
        }
        return nArray;
    }

    private static int[] targetIndices(VcfEmission[] vcfEmissionArray) {
        int[] nArray = new int[vcfEmissionArray.length];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = vcfEmissionArray[i] != null ? n++ : -1;
        }
        return nArray;
    }

    private static GL targetEmissions(Samples samples, VcfEmission[] vcfEmissionArray, int[] nArray) {
        VcfEmission[] vcfEmissionArray2 = new VcfEmission[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            vcfEmissionArray2[i] = vcfEmissionArray[nArray[i]];
        }
        return new BasicGL(samples, vcfEmissionArray2);
    }

    private void setRefHaplotypes(Markers markers, VcfEmission[] vcfEmissionArray) {
        this.refHaps.clear();
        RefHapPairs refHapPairs = new RefHapPairs(markers, this.refWindow.samples(), vcfEmissionArray);
        int n = refHapPairs.nSamples();
        for (int i = 0; i < n; ++i) {
            this.refHaps.add(new WrappedHapPair(refHapPairs, i));
        }
    }

    private void setTargetRefHaplotypes(Markers markers, VcfEmission[] vcfEmissionArray, int[] nArray) {
        assert (markers.nMarkers() == nArray.length);
        this.targetRefHaps.clear();
        VcfEmission[] vcfEmissionArray2 = new VcfEmission[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            vcfEmissionArray2[i] = vcfEmissionArray[nArray[i]];
        }
        RefHapPairs refHapPairs = new RefHapPairs(markers, this.refWindow.samples(), vcfEmissionArray2);
        int n = refHapPairs.nSamples();
        for (int i = 0; i < n; ++i) {
            this.targetRefHaps.add(new WrappedHapPair(refHapPairs, i));
        }
    }

    @Override
    public Markers markers() {
        return this.refEmissions.markers();
    }

    @Override
    public Markers nonRefMarkers() {
        return this.targetEmissions.markers();
    }

    @Override
    public int nMarkers() {
        return this.refEmissions.nMarkers();
    }

    @Override
    public int nNonRefMarkers() {
        return this.targetEmissions.markers().nMarkers();
    }

    @Override
    public int markerIndex(int n) {
        return this.refIndices[n];
    }

    @Override
    public int nonRefMarkerIndex(int n) {
        return this.targetIndices[n];
    }

    @Override
    public int nRefSamples() {
        return this.refWindow.nSamples();
    }

    @Override
    public Samples refSamples() {
        return this.refWindow.samples();
    }

    @Override
    public int nNonRefSamples() {
        return this.targetEmissions.nSamples();
    }

    @Override
    public Samples nonRefSamples() {
        return this.targetEmissions.samples();
    }

    @Override
    public int overlap() {
        return this.refWindow.overlap();
    }

    @Override
    public int nonRefOverlap() {
        return this.targetWindow.overlap();
    }

    @Override
    public int cumMarkerCnt() {
        return this.refWindow.cumMarkerCnt();
    }

    @Override
    public GL refEmissions() {
        return this.refEmissions;
    }

    @Override
    public GL nonRefEmissions() {
        return this.targetEmissions;
    }

    @Override
    public List<HapPair> restrictedRefHaps() {
        return new ArrayList<HapPair>(this.targetRefHaps);
    }

    @Override
    public List<HapPair> refHaps() {
        return new ArrayList<HapPair>(this.refHaps);
    }

    @Override
    public void close() {
        this.refWindow.close();
        this.targetWindow.close();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("vcf.AllData");
        return stringBuilder.toString();
    }
}

