% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_ct2env.R
\name{raster_ct2env}
\alias{raster_ct2env}
\title{Raster conversion of environmental data based on CT}
\usage{
raster_ct2env(longitude, latitude, clas, grid_data, option = 1,
  na.rm = TRUE)
}
\arguments{
\item{longitude}{Numeric vector containing longitudes}

\item{latitude}{Numeric vector containing latitudes}

\item{clas}{Integer containing the results of the synoptic classification.}

\item{grid_data}{Data frame containing the environmental data (i.e. precipitation, temperature, PM10, etc.)}

\item{option}{Integer (1 or 2), to manage latitude and longitude data when convert to raster. Try 2 if 1 is wrong and viceversa. Default is 1.}

\item{na.rm}{Logical. If TRUE, all the grid points are used to calculate the daily mean although NA exists. If FALSE, only grid points with the complete serie are used to compute the daily mean. Default is TRUE.}
}
\value{
a Raster Stack containing the environmental grids based on the weather types.
}
\description{
This function converts the dataframe of the environmental data based on the synoptic classification into a Raster Stack format.
}
\examples{
# Load data (precp_grid)
data(precp_grid)
# Converting our data, but without modifying time period
smode_mslp <- tidy_cuttime_nc(mslp)
precp_data <- tidy_cuttime_nc(precp_grid)
# classification performance
smode_clas <- synoptclas(smode_mslp$smode_data, ncomp = 6)
# convert all the precipitation maps based on CT to a raster stack
raster_precp <- raster_ct2env(longitude = precp_grid$lon,
                latitude = precp_grid$lat, clas = smode_clas$clas,
                grid_data = precp_data$smode_data, option = 2)

}
