% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_gen_RW.R
\name{data.gen.rw}
\alias{data.gen.rw}
\title{Generate Random walk time series.}
\usage{
data.gen.rw(nobs, drift = 0.2, sd = 1)
}
\arguments{
\item{nobs}{the data length to be generated}

\item{drift}{drift}

\item{sd}{the white noise in the data}
}
\value{
A list of 2 elements: random walk and random walk with drift
}
\description{
Generate Random walk time series.
}
\examples{
set.seed(154)
data.rw <- data.gen.rw(200)
plot.ts(data.rw$xd, ylim=c(-5,55), main="random walk", ylab='')
lines(data.rw$x, col=4); abline(h=0, col=4, lty=2); abline(a=0, b=.2, lty=2)
}
\references{
Shumway, R. H. and D. S. Stoffer (2011). Time series regression and exploratory data analysis. Time series analysis and its applications, Springer: 47-82.
}
