% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/measures.R
\name{pmse}
\alias{pmse}
\title{Compute the pMSE metric between synthetic and real data}
\usage{
pmse(synth, real, model = c("lr", "rf"), nrep = NULL)
}
\arguments{
\item{synth}{\code{[data.frame]} Synthesized data.}

\item{real}{\code{[real]} Data to compare with the synthesized data.}

\item{model}{\code{[character]} Model used to compute propensity scores. Options
are \code{"lr"}: logistic regression, and \code{"rf"}: random forest.}

\item{nrep}{\code{[integer]} Number of model repetitions to average the 
pMSE value over. Ignored for \code{lr}.}
}
\description{
The propensity mean squared error is defined as
\eqn{\frac{1}{N}\sum_{i=1}^N(p_i-c)^2}, where \eqn{c} is the number of
synthetic records, divided by the sum of the number of synthetic and real
records.
}
\examples{
scars <- synthesize(cars)
pmse(scars, cars)

}
\seealso{
Other measures: 
\code{\link{dcor}()},
\code{\link{dmean}()},
\code{\link{qa}()}
}
\concept{measures}
