% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fork.R
\name{eval_fork}
\alias{eval_fork}
\alias{eval_safe}
\title{Evaluate in fork}
\usage{
eval_fork(expr, envir = parent.frame(), tmp = tempfile("fork"),
  timeout = 60, std_out = stdout(), std_err = stderr())

eval_safe(expr, envir = parent.frame(), tmp = tempfile("fork"),
  timeout = 60, std_out = stdout(), std_err = stderr(), device = pdf)
}
\arguments{
\item{expr}{expression to evaluate}

\item{envir}{the \link{environment} in which expr is to be evaluated}

\item{tmp}{the value of \link{tempdir} inside the forked process}

\item{timeout}{maximum time in seconds to allow for call to return}

\item{std_out}{if and where to direct child process \code{STDOUT}. Must be one of
\code{TRUE}, \code{FALSE}, filename, connection object or callback function. See section
on \emph{Output Streams} below for details.}

\item{std_err}{if and where to direct child process \code{STDERR}. Must be one of
\code{TRUE}, \code{FALSE}, filename, connection object or callback function. See section
on \emph{Output Streams} below for details.}

\item{device}{graphics device to use in the fork, see \link{options}}
}
\description{
Version of \link{eval} which evaluates expression in a temporary fork so that it has no side
effects on the main R session, similar to \code{mccollect(mcparallel(expr))}. In \link{eval_safe}
the expression is wrapped in additional R code to catch errors, close graphics devices,
etc. Not available on Windows because it requires \code{fork()}.
}
\examples{
# Not available on Windows
if(.Platform$OS.type == "unix"){

# works like regular eval:
eval_safe(rnorm(5))

# Exceptions get propagated
test <- function() { doesnotexit() }
tryCatch(eval_safe(test()), error = function(e){
  cat("oh no!", e$message, "\\n")
})

# Honor interrupt and timeout, even inside C evaluations
try(eval_safe(svd(matrix(rnorm(1e8), 1e4)), timeout = 2))

# Capture output
outcon <- rawConnection(raw(0), "r+")
eval_safe(print(sessionInfo()), std_out = outcon)
rawToChar(rawConnectionValue(outcon))
}
}
