% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/misc.R
\name{build_trakt_url}
\alias{build_trakt_url}
\title{Assemble a trakt.tv API URL}
\usage{
build_trakt_url(section, target1 = NULL, target2 = NULL, target3 = NULL,
  target4 = NULL, extended = "min", ...)
}
\arguments{
\item{section}{The section of the API methods, like \code{shows} or \code{movies}.}

\item{target1,target2,target3,target4}{The target object, usually a show or
movie \code{slug} or something like \code{trending} and \code{popular}.
Will be concatenated after \code{section} to produce
a URL fragment like \code{movies/tron-legacy-2012/releases}.}

\item{extended}{Whether extended info should be returned. Defaults to \code{min}.}

\item{...}{Other params used as \code{queries}. Must be named arguments like \code{name = value}.}
}
\value{
A \code{character} of class \code{url}.
}
\description{
\code{build_trakt_url} assembles a trakt.tv API URL from different arguments.
The result should be fine for use with \link{trakt.api.call}, since that's what this
function was created for.
}
\note{
Please be aware that the result of this function is not verified to be a working trakt.tv
API URL. See \href{http://docs.trakt.apiary.io/#introduction/pagination}{the trakt.tv API docs for
more information}.
}
\examples{
build_trakt_url("shows", "breaking-bad", extended = "full")
build_trakt_url("shows", "popular", page = 3, limit = 5)
}
\seealso{
Other utility functions: \code{\link{pad}};
  \code{\link{parse_trakt_url}}
}

