% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.get_full_showdata.R
\name{trakt.get_full_showdata}
\alias{trakt.get_full_showdata}
\title{Get all the show data}
\usage{
trakt.get_full_showdata(query = NULL, slug = NULL, dropunaired = TRUE)
}
\arguments{
\item{query}{Keyword used for \link{trakt.search}. Optional.}

\item{slug}{Used if \code{query} is not specified. Optional, but gives exact results.}

\item{dropunaired}{If \code{TRUE}, episodes which have not aired yet are dropped.}
}
\value{
A \code{list} containing multiple \code{lists} and \code{data.frames} with show info.
}
\description{
\code{trakt.get_full_showdata} is a combination function of multiple
functions in this package. The idea is to easily execute all major functions
required to get a full show dataset.
}
\note{
This is primarily intended to be a convenience function for the case where you
really want all that data. If you're just derping around, maybe you should consider interactively
calling the other functions.
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
# Use the search within the function
breakingbad <- trakt.get_full_showdata("Breaking Bad")
# Alternatively, us a slug for explicit results
breakingbad <- trakt.get_full_showdata(slug = "breaking-bad")
}
}
\seealso{
Other show data: \code{\link{trakt.get_all_episodes}};
  \code{\link{trakt.seasons.season}};
  \code{\link{trakt.seasons.summary}};
  \code{\link{trakt.show.people}};
  \code{\link{trakt.show.ratings}};
  \code{\link{trakt.show.summary}};
  \code{\link{trakt.show.watching}};
  \code{\link{trakt.shows.popular}};
  \code{\link{trakt.shows.related}};
  \code{\link{trakt.shows.trending}};
  \code{\link{trakt.stats}}
}

